% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{bandwidth}
\alias{bandwidth}
\alias{bandwidth_nrd0}
\alias{bandwidth_nrd}
\alias{bandwidth_ucv}
\alias{bandwidth_bcv}
\alias{bandwidth_SJ}
\alias{bandwidth_dpi}
\title{Bandwidth estimators}
\usage{
bandwidth_nrd0(x, ...)

bandwidth_nrd(x, ...)

bandwidth_ucv(x, ...)

bandwidth_bcv(x, ...)

bandwidth_SJ(x, ...)

bandwidth_dpi(x, ...)
}
\arguments{
\item{x}{A numeric vector giving a sample.}

\item{...}{
  Arguments passed on to \code{\link[stats:bandwidth]{stats::bw.SJ}}
  \describe{
    \item{\code{nb}}{number of bins to use.}
    \item{\code{lower,upper}}{range over which to minimize.  The default is
    almost always satisfactory.  \code{hmax} is calculated internally
    from a normal reference bandwidth.}
    \item{\code{method}}{either \code{"ste"} ("solve-the-equation") or
    \code{"dpi"} ("direct plug-in").   Can be abbreviated.}
    \item{\code{tol}}{for method \code{"ste"}, the convergence tolerance for
    \code{\link[stats]{uniroot}}.  The default leads to bandwidth estimates
    with only slightly more than one digit accuracy, which is sufficient
    for practical density estimation, but possibly not for theoretical
    simulation studies.}
  }}
}
\value{
A single number giving the bandwidth
}
\description{
Bandwidth estimators for densities, used in the \code{bandwidth} argument
to density functions (e.g. \code{\link[=density_bounded]{density_bounded()}}, \code{\link[=density_unbounded]{density_unbounded()}}).

Supports \link[=automatic-partial-functions]{automatic partial function application}.
}
\details{
These are loose wrappers around the corresponding \code{bw.}-prefixed functions
in \pkg{stats}. See, for example, \code{\link[=bw.SJ]{bw.SJ()}}.

\code{\link[=bandwidth_dpi]{bandwidth_dpi()}}, which is the default bandwidth estimator in \pkg{ggdist},
is the Sheather-Jones direct plug-in estimator, i.e. \code{bw.SJ(..., method = "dpi")}.
}
\seealso{
\code{\link[=density_bounded]{density_bounded()}}, \code{\link[=density_unbounded]{density_unbounded()}}.
}
