% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student_t.R
\name{student_t}
\alias{student_t}
\alias{dstudent_t}
\alias{pstudent_t}
\alias{qstudent_t}
\alias{rstudent_t}
\title{Scaled and shifted Student's t distribution}
\usage{
dstudent_t(x, df, mu = 0, sigma = 1, log = FALSE)

pstudent_t(q, df, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qstudent_t(p, df, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rstudent_t(n, df, mu = 0, sigma = 1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{mu}{Location parameter (median)}

\item{sigma}{Scale parameter}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}
}
\value{
\itemize{
\item \code{dstudent_t} gives the density
\item \code{pstudent_t} gives the cumulative distribution function (CDF)
\item \code{qstudent_t} gives the quantile function (inverse CDF)
\item \code{rstudent_t} generates random draws.
}

The length of the result is determined by \code{n} for \code{rstudent_t}, and is the maximum of the lengths of
the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the result. Only the first elements
of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the
scaled and shifted Student's t distribution, parameterized by degrees of freedom (\code{df}),
location (\code{mu}), and scale (\code{sigma}).
}
\examples{

library(dplyr)
library(ggplot2)
library(forcats)

expand.grid(
  df = c(3,5,10,30),
  scale = c(1,1.5)
) \%>\%
  ggplot(aes(y = 0, dist = "student_t", arg1 = df, arg2 = 0, arg3 = scale, color = ordered(df))) +
  stat_slab(p_limits = c(.01, .99), fill = NA) +
  scale_y_continuous(breaks = NULL) +
  facet_grid( ~ scale) +
  labs(
    title = "dstudent_t(x, df, 0, sigma)",
    subtitle = "Scale (sigma)",
    y = NULL,
    x = NULL
  ) +
  theme_ggdist() +
  theme(axis.title = element_text(hjust = 0))

}
\seealso{
\code{\link[=parse_dist]{parse_dist()}} and parsing distribution specs and the \code{\link[=stat_slabinterval]{stat_slabinterval()}}
family of stats for visualizing them.
}
