% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_slabinterval.R
\name{stat_slab}
\alias{stat_slab}
\title{Slab (ridge) plot (shortcut stat)}
\usage{
stat_slab(
  mapping = NULL,
  data = NULL,
  geom = "slab",
  position = "identity",
  ...,
  slab_type = "pdf",
  p_limits = c(NA, NA),
  adjust = 1,
  trim = TRUE,
  expand = FALSE,
  breaks = "Sturges",
  outline_bars = FALSE,
  limits = NULL,
  n = 501,
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{\link[=stat_slab]{stat_slab()}} and \code{\link[=geom_slab]{geom_slab()}}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[=position_dodge]{position_dodge()}}) or \code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if
you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{size = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat. When paired with the default geom, \code{\link[=geom_slab]{geom_slab()}},
these include:
\describe{
\item{\code{normalize}}{How to normalize heights of functions input to the \code{thickness} aesthetic. One of:
\itemize{
\item \code{"all"}: normalize so that the maximum height across all data is \code{1}.
\item \code{"panels"}: normalize within panels so that the maximum height in each panel is \code{1}.
\item \code{"xy"}: normalize within the x/y axis opposite the \code{orientation} of this geom so
that the maximum height at each value of the opposite axis is \code{1}.
\item \code{"groups"}: normalize within values of the opposite axis and within each
group so that the maximum height in each group is \code{1}.
\item \code{"none"}: values are taken as is with no normalization (this should probably
only be used with functions whose values are in [0,1], such as CDFs).
}}
\item{\code{fill_type}}{What type of fill to use when the fill color or alpha varies within a slab. One of:
\itemize{
\item \code{"segments"}: breaks up the slab geometry into segments for each unique combination of fill color and
alpha value. This approach is supported by all graphics devices and works well for sharp cutoff values,
but can give ugly results if a large number of unique fill colors are being used (as in gradients,
like in \code{\link[=stat_gradientinterval]{stat_gradientinterval()}}).
\item \code{"gradient"}: a \code{grid::linearGradient()} is used to create a smooth gradient fill. This works well for
large numbers of unique fill colors, but requires R >= 4.1 and is not yet supported on all graphics devices.
As of this writing, the \code{png()} graphics device with \code{type = "cairo"}, the \code{svg()} device, the \code{pdf()}
device, and the \code{ragg::agg_png()} devices are known to support this option. On R < 4.1, this option
will fall back to \code{fill_type = "segment"} with a message.
\item \code{"auto"}: attempts to use \code{fill_type = "gradient"} if support for it can be auto-detected. On R >= 4.2,
support for gradients can be auto-detected on some graphics devices; if support is not detected, this
option will fall back to \code{fill_type = "segments"} (in case of a false negative, \code{fill_type = "gradient"}
can be set explicitly). On R < 4.2, support for gradients cannot be auto-detected, so this will always
fall back to \code{fill_type = "segments"}, in which case you can set \code{fill_type = "gradient"} explicitly
if you are using a graphics device that support gradients.
}}
}}

\item{slab_type}{The type of slab function to calculate: probability density (or mass) function (\code{"pdf"}),
cumulative distribution function (\code{"cdf"}), or complementary CDF (\code{"ccdf"}).}

\item{p_limits}{Probability limits (as a vector of size 2) used to determine the lower and upper
limits of the slab. E.g., if this is \code{c(.001, .999)}, then a slab is drawn
for the distribution from the quantile at \code{p = .001} to the quantile at \code{p = .999}. If the lower
(respectively upper) limit is \code{NA}, then the lower (upper) limit will be the minimum (maximum) of the
distribution's support if it is finite, and \code{0.001} (\code{0.999}) if it is not finite. E.g., if
\code{p_limits} is \code{c(NA, NA)} on a gamma distribution the effective value of \code{p_limits} would be
\code{c(0, .999)} since the gamma distribution is defined on \verb{(0, Inf)}; whereas on a normal distribution
it would be equivalent to \code{c(.001, .999)} since the normal distribution is defined on \verb{(-Inf, Inf)}.}

\item{adjust}{If \code{slab_type} is \code{"pdf"}, bandwidth for the density estimator for sample data
is adjusted by multiplying it by this value. See \code{\link[=density]{density()}} for more information.}

\item{trim}{For sample data, should the density estimate be trimmed to the range of the
input data? Default \code{TRUE}.}

\item{expand}{For sample data, should the slab be expanded to the limits of the scale? Default \code{FALSE}.}

\item{breaks}{If \code{slab_type} is \code{"histogram"}, the \code{breaks} parameter that is passed to
\code{\link[=hist]{hist()}} to determine where to put breaks in the histogram (for sample data).}

\item{outline_bars}{For sample data (if \code{slab_type} is \code{"histogram"}) and for discrete analytical
distributions (whose slabs are drawn as histograms), determines
if outlines in between the bars are drawn when the \code{slab_color} aesthetic is used. If \code{FALSE}
(the default), the outline is drawn only along the tops of the bars; if \code{TRUE}, outlines in between
bars are also drawn.}

\item{limits}{Manually-specified limits for the slab, as a vector of length two. These limits are combined with those
computed based on \code{p_limits} as well as the limits defined by the scales of the plot to determine the
limits used to draw the slab functions: these limits specify the maximal limits; i.e., if specified, the limits
will not be wider than these (but may be narrower). Use \code{NA} to leave a limit alone; e.g.
\code{limits = c(0, NA)} will ensure that the lower limit does not go below 0, but let the upper limit
be determined by either \code{p_limits} or the scale settings.}

\item{n}{Number of points at which to evaluate the function that defines the slab.}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (tidybayes had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a slab (ridge) geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Shortcut version of \code{\link[=stat_slabinterval]{stat_slabinterval()}} with \code{\link[=geom_slab]{geom_slab()}} for
creating slab (ridge) plots.

Roughly equivalent to:

\preformatted{stat_slabinterval(
  aes(size = NULL),
  geom = "slab",
  show.legend = NA
)
}
}
\details{
\strong{To visualize sample data}, such as a data distribution, samples from a
bootstrap distribution, or a Bayesian posterior, you can supply samples to
the \code{x} or \code{y} aesthetic.

\strong{To visualize analytical distributions}, you can use the \code{xdist} or \code{ydist}
aesthetic. For historical reasons, you can also use \code{dist} to specify the distribution, though
this is not recommended as it does not work as well with orientation detection.
These aesthetics can be used as follows:
\itemize{
\item \code{xdist}, \code{ydist}, and \code{dist} can be any distribution object from the \href{https://pkg.mitchelloharawild.com/distributional/}{distributional}
package (\code{\link[=dist_normal]{dist_normal()}}, \code{\link[=dist_beta]{dist_beta()}}, etc) or can be a \code{\link[posterior:rvar]{posterior::rvar()}} object.
Since these functions are vectorized,
other columns can be passed directly to them in an \code{\link[=aes]{aes()}} specification; e.g.
\code{aes(dist = dist_normal(mu, sigma))} will work if \code{mu} and \code{sigma} are columns in the
input data frame.
\item \code{dist} can be a character vector giving the distribution name. Then the  \code{arg1}, ... \code{arg9}
aesthetics (or \code{args} as a list column) specify distribution arguments. Distribution names
should correspond to R functions that have \code{"p"}, \code{"q"}, and \code{"d"} functions; e.g. \code{"norm"}
is a valid distribution name because R defines the \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, and \code{\link[=dnorm]{dnorm()}}
functions for Normal distributions.

See the \code{\link[=parse_dist]{parse_dist()}} function for a useful way to generate \code{dist} and \code{args}
values from human-readable distribution specs (like \code{"normal(0,1)"}). Such specs are also
produced by other packages (like the \code{brms::get_prior} function in brms); thus,
\code{\link[=parse_dist]{parse_dist()}} combined with the stats described here can help you visualize the output
of those functions.
}
}
\section{Computed Variables}{

The following variables are computed by this stat and made available for
use in aesthetic specifications (\code{\link[=aes]{aes()}}) using the \code{\link[=stat]{stat()}} or \code{\link[=after_stat]{after_stat()}}
functions:
\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{.width}: For intervals, the interval width as a numeric value in \verb{[0, 1]}.
\item \code{level}: For intervals, the interval width as an ordered factor.
\item \code{f}: For slabs, the output values from the slab function (such as the PDF, CDF, or CCDF),
determined by \code{slab_type}.
\item \code{pdf}: For slabs, the probability density function.
\item \code{cdf}: For slabs, the cumulative distribution function.
\item \code{n}: For slabs, the number of data points summarized into that slab. If the slab was created from
an analytical distribution via the \code{xdist}, \code{ydist}, or \code{dist} aesthetic, \code{n} will be \code{Inf}.
}
}

\section{Aesthetics}{

The slab+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{slab}, the \strong{point}, and
the \strong{interval}.

These \code{stat}s support the following aesthetics:

\itemize{
\item{\code{x}: x position of the geometry (when orientation = \code{"vertical"}); or sample data to be summarized
(when \code{orientation = "horizontal"} with sample data).}
\item{\code{y}: y position of the geometry (when orientation = \code{"horizontal"}); or sample data to be summarized
(when \code{orientation = "vertical"} with sample data).}
\item{\code{xdist}: When using analytical distributions, distribution to map on the x axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{ydist}: When using analytical distributions, distribution to map on the y axis: a \pkg{distributional}
object (e.g. \code{\link[=dist_normal]{dist_normal()}}) or a \code{\link[posterior:rvar]{posterior::rvar()}} object.}
\item{\code{dist}: When using analytical distributions, a name of a distribution (e.g. \code{"norm"}), a
\pkg{distributional} object (e.g. \code{\link[=dist_normal]{dist_normal()}}), or a \code{\link[posterior:rvar]{posterior::rvar()}} object. See \strong{Details}.}
\item{\code{args}: Distribution arguments (\code{args} or \code{arg1}, ... \code{arg9}). See \strong{Details}.}
}

In addition, in their default configuration (paired with \code{\link[=geom_slab]{geom_slab()}})
the following aesthetics are supported by the underlying geom:

\strong{Slab-specific aesthetics}

\itemize{
\item{\code{thickness}: The thickness of the slab at each \code{x} value (if \code{orientation = "horizontal"}) or
\code{y} value (if \code{orientation = "vertical"}) of the slab.}
\item{\code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}
\item{\code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}
\item{\code{justification}: Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to 0.5.}
\item{\code{datatype}: When using composite geoms directly without a \code{stat} (e.g. \code{\link[=geom_slabinterval]{geom_slabinterval()}}), \code{datatype} is used to
indicate which part of the geom a row in the data targets: rows with \code{datatype = "slab"} target the
slab portion of the geometry and rows with \code{datatype = "interval"} target the interval portion of
the geometry. This is set automatically when using ggdist \code{stat}s.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.}
\item{\code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{\link[=scale_colour_ramp]{scale_colour_ramp()}} for examples.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{size}: Width of the outline around the \strong{slab} (if visible). Also determines the width of
the line used to draw the \strong{interval} and the size of the \strong{point}, but raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{slab_size},
\code{interval_size}, or \code{point_size} aesthetics (below) to set sub-geometry line widths separately
(note that when size is set directly using the override aesthetics, interval and point
sizes are not affected by \code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}).}
\item{\code{stroke}: Width of the outline around the \strong{point} sub-geometry.}
\item{\code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.}
}

\strong{Slab-specific color/line override aesthetics}

\itemize{
\item{\code{slab_fill}: Override for \code{fill}: the fill color of the slab.}
\item{\code{slab_colour}: (or \code{slab_color}) Override for \code{colour}/\code{color}: the outline color of the slab.}
\item{\code{slab_alpha}: Override for \code{alpha}: the opacity of the slab.}
\item{\code{slab_size}: Override for \code{size}: the width of the outline of the slab.}
\item{\code{slab_linetype}: Override for \code{linetype}: the line type of the outline of the slab.}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{width}}
\item{\code{height}}
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{
library(dplyr)
library(ggplot2)
library(distributional)

theme_set(theme_ggdist())

# ON SAMPLE DATA
set.seed(1234)
df = data.frame(
  group = c("a", "b", "c"),
  value = rnorm(1500, mean = c(5, 7, 9), sd = c(1, 1.5, 1))
)
df \%>\%
  ggplot(aes(x = value, y = group)) +
  stat_slab()

# ON ANALYTICAL DISTRIBUTIONS
dist_df = data.frame(
  group = c("a", "b", "c"),
  mean =  c(  5,   7,   8),
  sd =    c(  1, 1.5,   1)
)
# Vectorized distribution types, like distributional::dist_normal()
# and posterior::rvar(), can be used with the `xdist` / `ydist` aesthetics
dist_df \%>\%
  ggplot(aes(y = group, xdist = dist_normal(mean, sd))) +
  stat_slab()

# RIDGE PLOTS
# "ridge" plots can be created by expanding the slabs to the limits of the plot
# (expand = TRUE), allowing the density estimator to be nonzero outside the
# limits of the data (trim = FALSE), and increasing the height of the slabs.
data.frame(
  group = letters[1:3],
  value = rnorm(3000, 3:1)
) \%>\%
  ggplot(aes(y = group, x = value)) +
  stat_slab(color = "black", expand = TRUE, trim = FALSE, height = 2)
}
\seealso{
See \code{\link[=geom_slab]{geom_slab()}} for the geom underlying this stat.
See \code{\link[=stat_slabinterval]{stat_slabinterval()}} for the stat this shortcut is based on.

Other slabinterval stats: 
\code{\link{stat_ccdfinterval}()},
\code{\link{stat_cdfinterval}()},
\code{\link{stat_eye}()},
\code{\link{stat_gradientinterval}()},
\code{\link{stat_halfeye}()},
\code{\link{stat_histinterval}()},
\code{\link{stat_interval}()},
\code{\link{stat_pointinterval}()}
}
\concept{slabinterval stats}
