% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_slabinterval.R
\name{stat_slabinterval}
\alias{stat_slabinterval}
\title{Meta-stat for computing slab functions and interval functions (ggplot stat)}
\usage{
stat_slabinterval(
  mapping = NULL,
  data = NULL,
  geom = "slabinterval",
  position = "identity",
  ...,
  orientation = NA,
  limits_function = NULL,
  limits_args = list(),
  limits = NULL,
  slab_function = NULL,
  slab_args = list(),
  n = 501,
  interval_function = NULL,
  interval_args = list(),
  point_interval = NULL,
  .width = c(0.66, 0.95),
  show_slab = TRUE,
  show_interval = TRUE,
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{limits_function}{A function that takes a data frame of aesthetics and returns a data frame with
columns \code{.lower} and \code{.upper} indicating the limits of the input for the slab function for that data frame.
The function may additionally take a \code{trans} argument which will be passed the scale
\link[scales:trans_new]{transformation} object applied to the coordinate space.}

\item{limits_args}{Additional arguments passed to \code{limits_function}}

\item{limits}{Limits for \code{slab_function}, as a vector of length two. These limits are combined with those
computed by the \code{limits_function} as well as the limits defined by the scales of the plot to determine the
limits used to draw the slab functions: these limits specify the maximal limits; i.e., if specified, the limits
will not be wider than these (but may be narrower). Use \code{NA} to leave a limit alone; e.g.
\code{limits = c(0, NA)} will ensure that the lower limit does not go below 0.}

\item{slab_function}{A function that takes a data frame of aesthetics and an \code{input} parameter (a vector
of function inputs), and returns a data frame with
columns \code{.input} (from the \code{input} vector) and \code{.value} (result of applying the function to
each value of input). Given the results of \code{slab_function}, \code{.value} will be translated into the
\code{f} aesthetic and \code{input} will be translated into either the \code{x} or \code{y} aesthetic
automatically depending on the value of \code{orientation}.}

\item{slab_args}{Additional arguments passed to \code{limits_function}}

\item{n}{Number of points at which to evaluate \code{slab_function}}

\item{interval_function}{Custom function for generating intervals (for most common use cases the \code{point_interval}
argument will be easier to use). This function takes a data frame of aesthetics and a \code{.width} parameter (a vector
of interval widths), and returns a data frame with
columns \code{.width} (from the \code{.width} vector), \code{.value} (point summary) and \code{.lower} and \code{.upper}
(endpoints of the intervals, given the \code{.width}). Output will be converted to the appropriate \code{x}- or
\code{y}-based aesthetics depending on the value of \code{orientation}. If \code{interval_function} is \code{NULL},
\code{point_interval} is used instead.}

\item{interval_args}{Additional arguments passed to \code{interval_function} or \code{point_interval}.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{show_interval}{Should the interval portion of the geom be drawn? Default \code{TRUE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
A meta-stat for computing slab and interval functions for use with \code{\link[=geom_slabinterval]{geom_slabinterval()}}
and its derivatives. Generally speaking not intended to be used directly: The API for
this stat is \strong{experimental and subject to change}. This is used as the basis
for several other more directly useful stats whose APIs are more stable; it is recommended
to use those instead.
}
\section{Aesthetics}{

These stats support the following aesthetics:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{thickness}
\item \code{size}
\item \code{group}
}
In addition, in their default configuration (paired with \code{\link[=geom_slabinterval]{geom_slabinterval()}}) the following aesthetics are supported by the underlying geom:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{colour_ramp}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{fill_ramp}
\item \code{ymin}
\item \code{ymax}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

# stat_slabinterval() is typically not that useful on its own.
# See vignette("slabinterval") for a variety of examples of the use of its
# shortcut geoms and stats, which are more useful than using
# stat_slabinterval() directly.

}
\seealso{
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geom version, intended
for use on data that has already been translated into function evaluations, points, and intervals.
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} for families of stats
built on top of this stat for common use cases (like \code{stat_halfeye}).
See \code{vignette("slabinterval")} for a variety of examples of use.
}
\keyword{internal}
