% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_asymmat.R
\name{geom_asymmat}
\alias{geom_asymmat}
\title{Asymmetrically filled symmetric matrix (using 'ggplot2')}
\usage{
geom_asymmat(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()} or
\code{aes_()}. If specified and \code{inherit.aes = TRUE} (the default),
it is combined with the default mapping at the top level of the plot.
You must supply mapping if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three options:
If \code{NULL} (the default) the data is inherited from the plot data as
specified in the call to \code{ggplot()}. A data frame, or other object,
will override the plot data. All objects will be fortified to produce
a data frame. See \code{fortify()} for which variables will be created.
A function will be called with a single argument, the plot data. The
return value must be a data frame, and will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{layer()}. These are often
aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA} (the default) includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes. It can
also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and should not inherit behaviour from the
default plot specification, e.g. \code{borders()}.}
}
\description{
Generate an asymmetric matrix with different fill values for top-left
    and bottom-right triangles and along the diagonal as a
    \code{ggplot()} object
}
\examples{
library(tibble)
library(ggplot2)
suppressMessages(library(dplyr))
tib <- tibble(g1 = c("A", "A", "B"),
              g2 = c("B", "C", "C"),
              val_1 = c(1, 2, 3),
              val_2 = c(-1, 0, 1))

tib

tib <- asymmetrise(tib, g1, g2)
tib$val_3 <- NA
tib$val_3[tib$g1 == tib$g2] <- c(1, 2, 3)
ggplot(tib, aes(x = g1, y = g2)) +
    geom_asymmat(aes(fill_tl = val_1, fill_br = val_2, fill_diag = val_3)) +
    scale_fill_br_gradient(low = "lightblue1", high = "dodgerblue") +
    scale_fill_tl_gradient(low = "lightpink", high = "tomato") +
    scale_fill_diag_gradient(low = "aquamarine", high = "forestgreen") +
    labs(fill_tl =  "top-left fill", fill_br = "bottom-right fill")

}
