% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetrise.R
\name{asymmetrise}
\alias{asymmetrise}
\alias{asymmetrize}
\title{Add all missing comparisons between two columns}
\usage{
asymmetrise(.data, .x, .y)

asymmetrize(.data, .x, .y)
}
\arguments{
\item{.data}{a tidy \code{data.frame} or \code{tibble}}

\item{.x, .y}{the data to add all comparisons between (ie. will be the
x and y-axes for \code{geom_asymmat()}}
}
\value{
a data table with new rows for the added comparisons
}
\description{
This function prepares input data for \code{geom_asymmat()} by
    adding in any missing comparisons to be plotted. Note that this function
    observes groups created with the \code{dplyr::group_by()} function. For
    the 'ggasym' package, this is useful for when you want to facet the plot:
    before "asymmetrizing" the data table, use \code{dplyr::group_by()},
    passing the column name you wish to later facet by. This functionality
    is demonstrated in the second example, below.
}
\section{Warning}{

This function does it's best when \code{x} or \code{y} are factors. If they
    have the same levels, then they are maintained. If the levels partially
    overlap, they are merged. Otherwise, the values are turned into
    characters and all levels dropped. If you are using factors, save
    yourself the headache and make both columns factors with the desired
    levels.
}

\examples{

df <- data.frame(a = c("A", "B", "C"),
                 b = c("C", "A", "B"),
                 untouched = c(1, 2, 3),
                 grouping_value = c("group1", "group1", "group2"),
                 stringsAsFactors = FALSE)
df

asymmetrise(df, a, b)

grouped_df <- dplyr::group_by(df, grouping_value)
asymmetrise(grouped_df, a, b)

}
