% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-time.R
\name{transition_time}
\alias{transition_time}
\title{Transition through distinct states in time}
\usage{
transition_time(time, range = NULL)
}
\arguments{
\item{time}{An unquoted expression giving the time, and thus state
membership, of each observation.}

\item{range}{The time range to animate. If \code{NULL} it will be set to the range
of \code{time}}
}
\description{
This is a variant of \code{\link[=transition_states]{transition_states()}} that is intended for data where
the states are representing specific point in time. The transition length
between the states will be set to correspond to the actual time difference
between them.
}
\section{Label variables}{

\code{transition_time} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{frame_time} gives the time that the current frame corresponds to
}
}

\section{Object permanence}{

\code{transition_time} uses the group aesthetic of each layer to identify
which rows in the input data correspond to the same graphic element and will
therefore define which elements will turn into each other between time points.
The group aesthetic, if not set, will be calculated from the interaction of all
discrete aesthetics in the layer (excluding \code{label}), so it is often better
to set it explicetly when animating, to make sure your data is interpreted in
the right way. If the group aesthetic is not set, and no discrete aesthetics
exists then all rows will have the same group. If the group aesthetic is not
unique in each state, then rows will be matched first by group and then by
index. Unmatched rows will appear/disappear, potentially using an enter or
exit function.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
anim <- ggplot(airquality, aes(Day, Temp)) +
  geom_point(aes(colour = factor(Month))) +
  transition_time(Day)

# Removing a time point will prolong the tweening between neighbouring time
# points so the time dimension stays linear
airquality_missing <- airquality[airquality$Day <= 10 | airquality$Day >= 20, ]
anim1 <- ggplot(airquality_missing, aes(Day, Temp)) +
  geom_point(aes(colour = factor(Month))) +
  transition_time(Day)

# Range can be constrained if needed
anim2 <- ggplot(airquality, aes(Day, Temp)) +
  geom_point(aes(colour = factor(Month))) +
  transition_time(Day, range = c(10L, 20L))

# The group aesthetic is used to connect elements
# No grouping
anim3 <- ggplot(airquality, aes(Day, Temp)) +
  geom_line() +
  transition_time(Month)

# Group by month
anim4 <- ggplot(airquality, aes(Day, Temp)) +
  geom_line(aes(group = Month)) +
  transition_time(Month) +
  enter_fade() +
  exit_fade()
}
\seealso{
Other transitions: 
\code{\link{transition_components}()},
\code{\link{transition_events}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_manual}()},
\code{\link{transition_null}()},
\code{\link{transition_reveal}()},
\code{\link{transition_states}()}
}
\concept{transitions}
