% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix.R
\name{fortify_matrix.matrix_upset}
\alias{fortify_matrix.matrix_upset}
\title{Build a Matrix for UpSet plot}
\usage{
\method{fortify_matrix}{matrix_upset}(data, ..., data_arg = caller_arg(data), call = NULL)
}
\arguments{
\item{data}{A matrix where each row represents an element, and each column
defines a set. The values in the matrix indicate whether the element is part
of the set. Any non-missing value signifies that the element exists in the
set.}

\item{...}{
  Arguments passed on to \code{\link[=fortify_matrix.list_upset]{fortify_matrix.list_upset}}
  \describe{
    \item{\code{mode}}{A string of \code{"distinct"}, \code{"intersect"}, or \code{"union"}
indicates the mode to define the set intersections. Check
\url{https://jokergoo.github.io/ComplexHeatmap-reference/book/upset-plot.html#upset-mode}
for details.}
  }}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected, e.g., \code{\link[rlang:stack]{caller_env()}}.
Developers can use it to improve messages. Not used by the user.}
}
\description{
Converts a matrix suitable for creating an UpSet plot. \code{\link[=tune.matrix]{tune.matrix()}}
helps convert \code{matrix} object to a \code{matrix_upset} object.
}
\section{ggalign attributes}{

\itemize{
\item \code{intersection_sizes}: An integer vector indicating the size of each
intersection.
\item \code{set_sizes}: An integer vector indicating the size of each set.
}
}

\seealso{
\code{\link[=tune.matrix]{tune.matrix()}}

Other fortify_matrix methods: 
\code{\link{fortify_matrix.GISTIC}()},
\code{\link{fortify_matrix.MAF}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.list_upset}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.phylo}()}
}
\concept{fortify_matrix methods}
