% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{pBar}
\alias{pBar}
\title{Mean Proportion: Binomial Data (p-chart)}
\usage{
pBar(y, n, na.rm = FALSE, ...)
}
\arguments{
\item{y}{Vector of binomial proportion data (not counts). Observations
may have a different area of opportunity, n.}

\item{n}{A vector representing the area of opportunity.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector of mean proportion, length equal to length of
parameter y.
}
\description{
Calculates overall mean proportion
for binomial proportion data acquired over a variable area of
opportunity.
}
\examples{
set.seed(5555)
p <- rbinom(n = 100, size = 30, prob = .2)
n <- rpois(100, 100)
pBar(y = p/n, n = n)

}
