% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{cBar_LCL}
\alias{cBar_LCL}
\title{Lower Control Limit: Count Data (c-chart)}
\usage{
cBar_LCL(y, na.rm = FALSE, ...)
}
\arguments{
\item{y}{Vector of count data. Each observation having the
same-area of opportunity.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A number; 3-sigma lower control limit (LCL). Function returns 0 for negative values.
}
\description{
Calculates lower control limit (LCL) for count data acquired
over the same-sized area of opportunity. Negative values are reported as 0.
}
\examples{
set.seed(5555)
y <- rpois(30, 9)
cBar_LCL(y)

}
