% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{pmx_config}
\alias{pmx_config}
\title{This function can be used to define the pmx configuration used in plots. e.g. Monolix/Nonmem}
\usage{
pmx_config(sys = "mlx", inputs, plots, ...)
}
\arguments{
\item{sys}{\code{charcarter} system used , monolix,nonmem,...}

\item{inputs}{\code{charcater} path to the inputs settings file (yaml format)}

\item{plots}{\code{charcater} path to the inputs settings file (yaml format)}

\item{...}{extra arguments not used}
}
\value{
\code{pmxConfig} object
}
\description{
This function can be used to define the pmx configuration used in plots. e.g. Monolix/Nonmem
}
\details{
To create a controller user can create a pmxConfig object using \cr
 - either an input template file \cr
 - or a plot template file \cr
 - or both. \cr
By default the 'standing' configuration will be used.
}
\examples{
# *************** Create a controller using custom plot configuration ***************** ------

library(ggPMX)
theophylline <- file.path(
  system.file(package = "ggPMX"), "testdata",
  "theophylline"
)
WORK_DIR <- file.path(theophylline, "Monolix")
input_file <- file.path(theophylline, "data_pk.csv")


# create a controller with a custom plots template
ctr <-  pmx_mlx(
  config = pmx_config(
    plots=file.path( system.file(package = "ggPMX"),"examples/plots.yaml"),
    inputs = system.file(package = "ggPMX","examples/custom_inputs.yaml")
  ),
  directory = WORK_DIR,
  input = input_file,
  dv = "Y",
  dvid = "DVID",
  cats = c("SEX"),
  conts = c("WT0", "AGE0"),
  strats = "STUD"
)

## get the list of plots
ctr \%>\% plots
ctr \%>\% get_plot("custom_res_time")
ctr \%>\% get_plot("custom_npde_time")

}
