% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{set_plot}
\alias{set_plot}
\title{Create a new plot  of the desired type}
\usage{
set_plot(
  ctr,
  ptype = c("IND", "DIS", "SCATTER", "ETA_PAIRS", "ETA_COV", "PMX_QQ", "VPC",
    "PMX_DENS"),
  pname,
  use.defaults = TRUE,
  filter = NULL,
  strat.color = NULL,
  strat.facet = NULL,
  color.scales = NULL,
  trans = NULL,
  ...
)
}
\arguments{
\item{ctr}{\code{pmxClass} controller object}

\item{ptype}{plot type can be:
\itemize{
 \item{"IND"}{ Individual plot type: \code{\link{individual}} }
 \item{"DIS"}{ Distribution plot type : \code{\link{distrib}}}
 \item{"SCATTER"}{ Residual plot type :\code{\link{residual}}}
}}

\item{pname}{plot name, if missing it will be created using function aestetics}

\item{use.defaults}{\code{logical} if FALSE do not use defaults defined in yaml init files}

\item{filter}{optional filter which will be applied to plotting data}

\item{strat.color}{\code{character}}

\item{strat.facet}{\code{formula} define categorical stratification as formula}

\item{color.scales}{\code{list} can be used with strat.color to set scale_color_manual}

\item{trans}{\code{list}{transformation operator}}

\item{...}{other plot parameters to configure \code{\link{pmx_gpar}}.}
}
\value{
invisible ctr object
}
\description{
Create a new plot  of the desired type
}
\seealso{
Other pmxclass: 
\code{\link{get_cats}()},
\code{\link{get_conts}()},
\code{\link{get_covariates}()},
\code{\link{get_data}()},
\code{\link{get_occ}()},
\code{\link{get_plot_config}()},
\code{\link{get_plot}()},
\code{\link{get_strats}()},
\code{\link{plot_names}()},
\code{\link{plots}()},
\code{\link{pmx_update}()},
\code{\link{set_data}()}
}
\concept{pmxclass}
