% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-heat-grid.R
\name{geom_heat_grid}
\alias{geom_heat_grid}
\title{Heatgrid}
\usage{
geom_heat_grid(
  outside,
  outside_name = NULL,
  outside_colors = c("#FED7D8", "#FE8C91", "#F5636B", "#E72D3F", "#C20824"),
  inside,
  inside_name = NULL,
  inside_colors = c("gray100", "gray85", "gray50", "gray35", "gray0"),
  r = 3,
  ...
)
}
\arguments{
\item{outside}{The column name for the outside portion of heatgrid.}

\item{outside_name}{The label name (in quotes) for the legend of the outside
rendering. Default is \code{NULL}.}

\item{outside_colors}{A color vector, usually as hex codes.}

\item{inside}{The column name for the inside portion of heatgrid.}

\item{inside_name}{The label name (in quotes) for the legend of the inside
rendering. Default is \code{NULL}.}

\item{inside_colors}{A color vector, usually as hex codes.}

\item{r}{The value that controls how large of the inside portion with respect
to the outside one. When \code{r} is larger, the inside get smaller.
Default value is 3.}

\item{...}{\code{...} accepts any arguments \code{scale_fill_gradientn()} has
.}
}
\value{
A heatgrid comparing two data sources.
}
\description{
The heatgrid geom is used to create a modified heat map that uses luminance
to show the values from two sources on the same plot.
}
\examples{

# heatgrid with categorical variables only

library(ggplot2)

data <- data.frame(x = rep(c("a", "b", "c"), 3),
                   y = rep(c("d", "e", "f"), 3),
                   outside_values = rep(c(1,5,7),3),
                   inside_values = rep(c(2,3,4),3))

ggplot(data, aes(x,y)) +
geom_heat_grid(outside = outside_values,
               inside = inside_values)

# Making the inside smaller by setting r to be larger.

ggplot(data, aes(x,y)) +
geom_heat_grid(outside = outside_values,
               inside = inside_values,
               r = 5)

# heatgrid with numeric variables only

data <- data.frame(x = rep(c(1, 2, 3), 3),
                   y = rep(c(1, 2, 3), 3),
                   outside_values = rep(c(1,5,7),3),
                   inside_values = rep(c(2,3,4),3))

ggplot(data, aes(x,y)) +
geom_heat_grid(outside = outside_values,
               inside = inside_values)


# heatgrid with a mixture of numeric and categorical variables

data <- data.frame(x = rep(c("a", "b", "c"), 3),
                   y = rep(c(1, 2, 3), 3),
                   outside_values = rep(c(1,5,7),3),
                   inside_values = rep(c(2,3,4),3))

ggplot(data, aes(x,y)) +
geom_heat_grid(outside = outside_values,
               inside = inside_values)




}
