% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chernoffGrob.R
\name{chernoffGrob}
\alias{chernoffGrob}
\title{Draw a smiley face}
\usage{
chernoffGrob(x = 0.5, y = 0.5, size = 1, colour = "black", fill = NA,
  alpha = 1, smile = 1, brow = NA, nose = FALSE)
}
\arguments{
\item{x}{horizontal position}

\item{y}{vertical position}

\item{size}{area of the face}

\item{colour}{colour of outlines and features}

\item{fill}{fill colour}

\item{alpha}{transparency, where 0 is transparent and 1 is opaque}

\item{smile}{amount of smiling/frowning}

\item{brow}{eyebrow angle, to represent anger or concern}

\item{nose}{logical. Adds a nose to the face}
}
\value{
A \code{\link[grid]{grobTree}} object.
}
\description{
Uses \code{\link[grid]{Grid}} graphics to draw a face.
}
\examples{
face <- chernoffGrob(.5, .5, size = 1e3, smile = -1, brow = 1, colour = 'navy', fill = 'lightblue')
grid::grid.newpage()
grid::grid.draw(face)
}
\seealso{
\code{\link{geom_chernoff}}
}
