% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSUtils.R
\docType{class}
\name{GSUtils}
\alias{GSUtils}
\title{Geoserver REST API Manager Utils}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with static util methods for communication
with the REST API of a GeoServer instance.
}
\description{
Geoserver REST API Manager Utils

Geoserver REST API Manager Utils
}
\section{Static methods}{

\describe{
 \item{\code{getUserAgent()}}{
   This method is used to get the user agent for performing GeoServer API requests.
   Here the user agent will be compound by geosapi package name and version.
 }
 \item{\code{getUserToken(user, pwd)}}{
   This method is used to get the user authentication token for performing GeoServer
   API requests. Token is given a Base64 encoded string.
 }
 \item{\code{GET(url, user, pwd, path, verbose)}}{
   This method performs a GET request for a given \code{path} to GeoServer REST API
 }
 \item{\code{PUT(url, user, pwd, path, filename, contentType, verbose)}}{
   This method performs a PUT request for a given \code{path} to GeoServer REST API,
   to upload a file of name \code{filename} with given \code{contentType}
 }
 \item{\code{POST(url, user, pwd, path, content, contentType, verbose)}}{
   This method performs a POST request for a given \code{path} to GeoServer REST API,
   to post content of given \code{contentType}
 }
 \item{\code{DELETE(url, user, pwd, path, verbose)}}{
   This method performs a DELETE request for a given GeoServer resource identified
   by a \code{path} in GeoServer REST API
 }
 \item{\code{parseResponseXML(req)}}{
   Convenience method to parse XML response from GeoServer REST API.
 }
 \item{\code{getPayloadXML(obj)}}{
   Convenience method to create payload XML to send to GeoServer.
 }
 \item{\code{setBbox(minx, miny, maxx, maxy, bbox, crs)}}{
   Creates an list object representing a bbox. Either from coordinates or from
   a \code{bbox} object (matrix).
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSUtils-clone}{\code{GSUtils$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSUtils-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSUtils-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSUtils$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
