% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSShapefileDataStore.R
\docType{class}
\name{GSShapefileDataStore}
\alias{GSShapefileDataStore}
\title{Geoserver REST API ShapeFileDataStore}
\format{\code{\link{R6Class}} object.}
\usage{
GSShapefileDataStore
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer Shapefile dataStore
}
\description{
Geoserver REST API ShapeFileDataStore
}
\section{Methods}{

\describe{
   \item{\code{new(xml, dataStore, description, enabled, url)}}{
     Instantiates a GSShapefileDataStore object
   }
   \item{\code{setUrl(url)}}{
     Set the spatial files data URL
   }
   \item{\code{setCharset(charset)}}{
     Set the charset used for DBF file. Default value is 'ISO-8859-1'
   }
   \item{\code{setCreateSpatialIndex(create)}}{
     Set the 'Create Spatial Index' option. Default is TRUE
   }
   \item{\code{setMemoryMappedBuffer(buffer)}}{
     Set the 'Memory Mapped Buffer' option. Default is TRUE
   }
   \item{\code{CacheReuseMemoryMaps(maps)}}{
     Set the 'Cache & Reuse Memory Maps' option. Default is TRUE
   }
   \item{\code{setDefautConnectionParameters()}}{
     Set the defaut connection paramaters
   }
}
}

\examples{
GSShapefileDataStore$new(dataStore="ds", description = "des",
                         enabled = TRUE, url = "file://data/shape.shp")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{ESRI}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{shapefile}
