% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.pls.r
\name{compare.pls}
\alias{compare.pls}
\title{Comparisons of Effect Sizes from Partial Least Squares}
\usage{
compare.pls(...)
}
\arguments{
\item{...}{saved analyses of class, "pls"}
}
\value{
An object of class, "compare.pls", returns a list of the following
\item{sample.z}{A vector of effect sizes for each sample.}
\item{sample.r.sd}{A vector of standard deviations for each sampling distribution.}
\item{pairwise.z}{A matrix of pariwise, two-sample z scores betwen all pairs of effect sizes.}
\item{pairwise.p}{A matrix of corresponding P-values.}
}
\description{
Function performs an analysis to compare the effect sizes of two or more PLS effects
}
\details{
The function statistically compares the effect sizes of two or more PLS analyses.  Typically, this
function might be used to compare levels of integration between two or more samples, each measuring morphological 
integration between different modules.  In such cases, the PLS correlation coefficient, r, is not a good
measure of integration effect, as its expected value is dependent on both the number of specimens and number 
of variables (Adams and Collyer 2016).  This analysis calculates effect sizes as standard deviates, z, and 
performs two-sample z-tests, using the pooled standard error from the sampling distributions of the PLS analyses.
 
 To use this function, simply perform \code{\link{two.b.pls}}, \code{\link{integration.test}}, or 
 \code{\link{phylo.integration}} on as many samples as desired.  Any number of objects of class "pls" can be input.
 
 Similar versions of this function will designed for alternative test statistics, in the future.
}
\examples{
# Example of comparative morphological intgration between pupfish head and body shapes

 data(pupfish) # GPA previously performed
  
 group <- factor(paste(pupfish$Pop, pupfish$Sex, sep = "."))
 levels(group)
  
 tail.LM <- c(1:3, 5:9, 18:38)
 head.LM <- (1:56)[-tail.LM]

 tail.coords <- pupfish$coords[tail.LM,,]
 head.coords <- pupfish$coords[head.LM,,]

 # Subset by group
 tail.coords.gp <- coords.subset(tail.coords, group)
 head.coords.gp <- coords.subset(head.coords, group)

 integ.tests <- Map(function(x,y) integration.test(x, y, iter=499), head.coords.gp, tail.coords.gp)

 integ.tests$Marsh.F
 integ.tests$Marsh.M
 integ.tests$Sinkhole.F
 integ.tests$Sinkhole.M

 group.Z <- compare.pls(integ.tests)
 summary(group.Z)

 # Sexual dimorphism in morpholigical intrgartion in one population
 # but not the other

 # can also list different PLS analyses, seprately

 compare.pls(MF = integ.tests$Marsh.F, MM = integ.tests$Marsh.M)

}
\author{
Michael Collyer
}
\references{
Adams, D.C and M.L. Collyer. 2016. On the comparison of the strength of morphological 
integration across morphometric datasets. Evolution (in press)
}
\keyword{analysis}

