% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint}
\alias{lint}
\title{Lint geojson}
\usage{
lint(x, ...)
}
\arguments{
\item{x}{Input, a geojson character string or list}

\item{...}{Further args passed on to helper functions.}
}
\description{
Lint geojson
}
\details{
This function is Deprecated - and will be removed in the next version of 
this package. See \code{\link{geojsonio-deprecated}} for more information
}
\examples{
\dontrun{
lint('{"type": "FooBar"}')
lint('{ "type": "FeatureCollection" }')
lint('{"type":"Point","geometry":{"type":"Point","coordinates":[-80,40]},"properties":{}}')

# From a list turned into geo_list
mylist <- list(list(latitude=30, longitude=120, marker="red"),
               list(latitude=30, longitude=130, marker="blue"))
x <- geojson_list(mylist)
class(x)
lint(x)

# A file
file <- system.file("examples", "zillow_or.geojson", package = "geojsonio")
lint(as.location(file))

# A URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
lint(as.location(url))

# from json (jsonlite class)
x <- jsonlite::minify('{ "type": "FeatureCollection" }')
class(x)
lint(x)

# From SpatialPoints class
library("sp")
a <- c(1,2,3,4,5)
b <- c(3,2,5,1,4)
(x <- SpatialPoints(cbind(a,b)))
class(x)
lint(x)

# From a data.frame
## need to specify what columns are lat and long with a data.frame
lint(us_cities[1:2,], lat='lat', lon='long')

# From numeric
vec <- c(32.45,-99.74)
lint(vec)

# From a list
mylist <- list(list(latitude=30, longitude=120, marker="red"),
               list(latitude=30, longitude=130, marker="blue"))
lint(mylist)
}
}
