% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson_read.R
\name{geojson_read}
\alias{geojson_read}
\title{Read geojson or other formats from a local file or a URL}
\usage{
geojson_read(x, method = "web", parse = FALSE, what = "list", ...)
}
\arguments{
\item{x}{(character) Path to a local file or a URL.}

\item{method}{(character) One of "web" (default) or "local". Matches on 
partial strings. This parameter determines how the data is 
read. "web" means we use the Ogre web service, and "local" means we use 
\pkg{rgdal}. See Details fore more.}

\item{parse}{(logical) To parse geojson to data.frame like structures if 
possible. Default: \code{FALSE}}

\item{what}{(character) What to return. One of "list" or "sp" (for 
Spatial class). Default: "list". If "sp" chosen, forced to 
\code{method="local"}.}

\item{...}{Additional parameters passed to \code{\link[rgdal]{readOGR}}}
}
\description{
Read geojson or other formats from a local file or a URL
}
\details{
Uses \code{\link{file_to_geojson}} internally to give back geojson, 
and other helper functions when returning spatial classes.

This function supports various geospatial file formats from a URL, as well 
as local kml, shp, and geojson file formats.
}
\section{Method parameter}{

The web option uses the Ogre web API. Ogre currently has an output size 
limit of 15MB. See here \url{http://ogre.adc4gis.com/} for info on the 
Ogre web API. The local option uses the function \code{\link{writeOGR}} 
from the package rgdal.
}

\section{Ogre}{

Note that for Shapefiles, GML, MapInfo, and VRT, you need to send zip files
to Ogre. For other file types (.bna, .csv, .dgn, .dxf, .gxt, .txt, .json,
.geojson, .rss, .georss, .xml, .gmt, .kml, .kmz) you send the actual file 
with that file extension.
}

\section{Linting GeoJSON}{

If you're having trouble rendering GeoJSON files, ensure you have a valid
GeoJSON file by running it through the package \pkg{geojsonlint}, which 
has a variety of different GeoJSON linters.
}

\examples{
\dontrun{
# From a file
file <- system.file("examples", "california.geojson", package = "geojsonio")
out <- geojson_read(file)

# From a URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, method = "local")

# Use as.location first if you want
geojson_read(as.location(file))

# use jsonlite to parse to data.frame structures where possible
geojson_read(url, method = "local", parse = TRUE)

# output a SpatialClass object
## read kml
file <- system.file("examples", "norway_maple.kml", package = "geojsonio")
geojson_read(as.location(file), what = "sp")
## read geojson
file <- system.file("examples", "california.geojson", package = "geojsonio")
geojson_read(as.location(file), what = "sp")
## read geojson from a url
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, what = "sp")
## read from a shape file
file <- system.file("examples", "bison.zip", package = "geojsonio")
dir <- tempdir()
unzip(file, exdir = dir)
shpfile <- list.files(dir, pattern = ".shp", full.names = TRUE)
geojson_read(shpfile, what = "sp")

x <- "https://raw.githubusercontent.com/johan/world.geo.json/master/countries.geo.json"
geojson_read(x, method = "local", what = "sp")
geojson_read(x, method = "local", what = "list")

utils::download.file(x, destfile = basename(x))
geojson_read(basename(x), method = "local", what = "sp")

# doesn't work right now
## file <- system.file("examples", "feature_collection.geojson", 
##   package = "geojsonio")
## geojson_read(file, what = "sp")
}
}
