% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_files}
\alias{merge_files}
\title{merge json files (or any kind of text files) from a directory}
\usage{
merge_files(INPUT_FOLDER, OUTPUT_FILE, CONCAT_DELIMITER = "\\n",
  verbose = FALSE)
}
\arguments{
\item{INPUT_FOLDER}{a character string specifying a path to the input folder}

\item{OUTPUT_FILE}{a character string specifying a path to the output file}

\item{CONCAT_DELIMITER}{a character string specifying the delimiter to use when merging the files}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed in the console.}
}
\description{
merge json files (or any kind of text files) from a directory
}
\details{
This function is meant for json files but it can be applied to any kind of text files. It takes an input folder (\emph{INPUT_FOLDER}) and an output file
(\emph{OUTPUT_FILE}) and merges all files from the \emph{INPUT_FOLDER} to a single \emph{OUTPUT_FILE} using the concatenation delimiter (\emph{CONCAT_DELIMITER}).
}
\examples{

\dontrun{
library(geojsonR)

merge_files(INPUT_FOLDER = "/my_folder/", OUTPUT_FILE = "output_file.json")
}
}
