% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\docType{methods}
\name{spc.lapply}
\alias{spc.lapply}
\alias{spc.lapply,SpcList-method}
\title{Apply a function over a Spclist}
\usage{
spc.lapply(X, FUN, ...)

\S4method{spc.lapply}{SpcList}(X, FUN, ...)
}
\arguments{
\item{X}{A \code{SpcList} object .}

\item{FUN}{function to be applied to each element of X.}

\item{...}{optional arguments to FUN.}
}
\value{
list or SpcList object.
}
\description{
lapply returns a list of the same length as X, each element of which is the result of applying FUN to the corresponding element of X.
}
\examples{
 
sp=spc.example_spectra()
BL=spc.makeSpcList(sp,"CAST")
#Counts rows (returns a list object)
spc.lapply(BL,function(x) {nrow(x)})
#Perform arithmetic operations on all Spectra elements. Returns a SpcList object.
spc.lapply(BL,function(x) {x^2+1})

}
