\name{image.kriging}

\alias{image.kriging}
\alias{persp.kriging}
\alias{contour.kriging}
\alias{prepare.graph.kriging}
\alias{plot.1d}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Image or Perspective Plot with Kriging Results}

\description{
  Plots image or perspective plots with results of the kriging
  calculations.
}

\usage{
\method{image}{kriging}(x, locations, borders, values = x$predict,
              coords.data, xlim, ylim, x.leg, y.leg, \dots)
\method{contour}{kriging}(x, locations, borders, values = x$predict,
              coords.data, xlim, ylim, filled=FALSE, \dots)
\method{persp}{kriging}(x, locations, borders, values = x$predict, \dots)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of the  class \code{kriging}, typically
    with the output of the functions \code{\link{krige.conv}} or \code{\link{ksline}}.  }
  \item{locations}{an \eqn{n \times 2}{n x 2} matrix with the
    coordinates of the prediction locations, which should define a
    regular grid
    in order to be plotted by \code{\link{image}} or
    \code{\link{persp}}. By default does not need to be provided and
    evaluates the attribute "prediction.locations" from the input object. }
  \item{borders}{an \eqn{n \times 2}{n x 2} matrix with the
    coordinates defining the borders of a region inside the grid defined
    by \code{locations}. Elements in the
    argument \code{values} are assigned to locations internal to the
    borders and \code{NA}'s to the external ones.
  }
  \item{values}{a vector with values to be plotted. Defaults to \code{obj$predict}.  }
  \item{coords.data}{optional. If an \eqn{n \times 2}{n x 2}
    matrix with the data coordinates is
    provided, points indicating the data locations are included in the
    plot.  }
  \item{xlim, ylim} {the range to be encompassed by the x and y axes.  }
  \item{x.leg, y.leg}{limits for the legend in the horizontal and vertical directions.  }
  \item{filled}{logical. If \code{FALSE} the function
    \code{\link{contour}} is used otherwise
    \code{\link{filled.contour}}. Defaults to \code{FALSE}.  }
  \item{\dots}{further arguments to be passed to the functions
    \code{\link{image}}, \code{\link{contour}}, \code{\link{filled.contour}}, \code{\link{persp}} or
    \code{\link{legend.krige}}.
    For instance, the
    argument \code{zlim} can be used to set the the minimum and maximum
    `z' values for which colors should be plotted.
    See documentation for those function for
    possible arguments.
  }   
}

%\details{
%}

\value{
  An image or perspective plot is produced o the current graphics
  device.
  No values are returned.
}

\references{
  Further information on the package \bold{geoR} can be found at:\cr
  \url{http://www.est.ufpr.br/geoR}.
}

\author{
  Paulo J. Ribeiro Jr. \email{Paulo.Ribeiro@est.ufpr.br}, \cr
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk}.
}


%\note{ ~~further notes~~ }

 
\seealso{\code{\link{krige.conv}} and \code{\link{ksline}} for kriging
  calculations. Documentation for
  \code{\link{image}}, \code{\link{contour}}, \code{\link{filled.contour}} and  \code{\link{persp}} contain basic information
  on the plotting functions.}

\examples{
data(s100) 
loci <- expand.grid(seq(0,1,l=31), seq(0,1,l=31))
kc <- krige.conv(s100, loc=loci,
                 krige=krige.control(cov.pars=c(1, .25)))

image(kc, loc=loci)
contour(kc, loc=loci)
persp(kc, loc=loci, theta=20, phi=20)

op <- par(no.readonly = TRUE)
par(mfrow=c(1,2), mar=c(3,3,0,0), mgp=c(1.5, .8,0))
image(kc, loc=loci)
image(kc, loc=loci, val=sqrt(kc$krige.var))

# notice different ways to add the legends and pass arguments:
image(kc, loc=loci, ylim=c(-0.2, 1), x.leg=c(0,1), y.leg=c(-0.2, -0.1))
image(kc, loc=loci, val=kc$krige.var, ylim=c(-0.2, 1))
legend.krige(y.leg=c(-0.2,-0.1), x.leg=c(0,1), val=sqrt(kc$krige.var))

image(kc, loc=loci, ylim=c(-0.2, 1), x.leg=c(0,1), y.leg=c(-0.2, -0.1), cex=1.5)
image(kc, loc=loci, ylim=c(-0.2, 1), x.leg=c(0,1), y.leg=c(-0.2, -0.1), off=0.5)

image(kc, loc=loci, xlim=c(0, 1.2))
legend.krige(x.leg=c(1.05,1.1), y.leg=c(0,1),kc$pred, vert=TRUE)
image(kc, loc=loci, xlim=c(0, 1.2))
legend.krige(x.leg=c(1.05,1.1), y.leg=c(0,1),kc$pred, vert=TRUE, off=1.5, cex=1.5)

par(op)
}

\keyword{spatial}
\keyword{dplot}
