% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes.R
\name{gene_search}
\alias{gene_search}
\title{Search for Gene Information Based on a Query}
\usage{
gene_search(
  queryFields,
  queryValues,
  fieldsFilter = c("geneID", "symbol", "crossReference.enseGeneID"),
  excludeFields = NULL,
  page = 1,
  limit = 10,
  searchType = "and",
  orderBy = "geneID",
  sortDirection = "asc",
  responseType = "json",
  matchType = "exact",
  organismType = list(c("9606")),
  ontologyCategories = list(),
  debug = 0,
  options = list()
)
}
\arguments{
\item{queryFields}{A character vector specifying the fields to search within the gene data.}

\item{queryValues}{A numeric vector representing the values to search for within the specified fields.}

\item{fieldsFilter}{An optional character vector specifying which fields to include in the response.}

\item{excludeFields}{If fieldsFilter is not provided (empty), all fields are returned, here you can specify the fields you want to exclude.}

\item{page}{An integer specifying the page number of the search results to retrieve.}

\item{limit}{An integer specifying the maximum number of results to return per page.}

\item{searchType}{A character string indicating whether to use 'and' or 'or' logic for multiple search conditions.}

\item{orderBy}{A character string specifying which field to sort the results by.}

\item{sortDirection}{A character string indicating the sort direction ('asc' or 'desc').}

\item{responseType}{A character string indicating the type of response to expect ('json' or 'csv').}

\item{matchType}{A character string indicating the type of match to perform ('exact' or 'regex').}

\item{organismType}{A list of organism type IDs to filter the search results.}

\item{ontologyCategories}{A list of ontology category IDs to filter the search results.}

\item{debug}{An integer value indicating whether to enable debug mode (1) or not (0).}

\item{options}{A list of additional options for the API request, including endpoint, api_key, timeout, and user-agent.}
}
\value{
Depending on the responseType parameter, this function returns a list with different elements:
If responseType is 'json', the function returns a list containing the HTTP status code ('status_code'),
the parsed JSON content ('content') representing gene information matching the search criteria,
and the original request body sent to the API ('request_body').
If responseType is 'csv', the function returns a list containing the HTTP status code ('status_code'),
a data frame ('content') constructed from the CSV response representing gene information,
and the original request body sent to the API ('request_body').
In case of an HTTP status code different from 200, the content part of the return value provides the received error message or data.
}
\description{
This function allows users to search for gene information by sending a POST request
to the 'Genular' API. It accepts various search parameters and returns information
about genes that match the search criteria.
}
\examples{
\donttest{
# Define search parameters
queryFields <- list(c("geneID")) # or c("geneID", "symbol" ...)
queryValues <- c(1, 56, 70)
searchType <- "or"
fieldsFilter <- c("geneID", "symbol", "crossReference.enseGeneID")

# Execute the search
gene_search_results <- gene_search(queryFields, queryValues, 
                                     fieldsFilter, searchType = searchType, 
                                     page = 1, limit = 10)

# Print the results
print(gene_search_results)
}
}
