% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes.R
\name{fetch_all_gene_search_results}
\alias{fetch_all_gene_search_results}
\title{Fetch All Pages of Gene Search Results}
\usage{
fetch_all_gene_search_results(
  queryFields,
  queryValues,
  fieldsFilter = c("geneID", "symbol", "crossReference.enseGeneID", "ontology.id",
    "ontology.term", "ontology.cat"),
  searchType = "or",
  orderBy = "geneID",
  sortDirection = "asc",
  responseType = "json",
  matchType = "exact",
  organismType = list(c(9606)),
  ontologyCategories = list(),
  limit = 5,
  debug = 0,
  options = list()
)
}
\arguments{
\item{queryFields}{A character vector specifying the fields to search within the gene data.}

\item{queryValues}{A numeric/character vector representing the values to search for within the specified fields.}

\item{fieldsFilter}{A vector specifying which fields to include in the response.}

\item{searchType}{Indicates whether to use 'and' or 'or' logic for multiple search conditions.}

\item{orderBy}{Specifies which field to sort the results by.}

\item{sortDirection}{Indicates the sort direction ('asc' or 'desc').}

\item{responseType}{Indicates the type of response to expect ('json' or 'csv').}

\item{matchType}{Indicates the type of match to perform ('exact' or 'regex').}

\item{organismType}{A list of organism type IDs to filter the search results.}

\item{ontologyCategories}{A list of ontology category IDs to filter the search results.}

\item{limit}{The maximum number of results to return per page.}

\item{debug}{An integer value indicating whether to enable debug mode (1) or not (0).}

\item{options}{A list of additional options for the API request, including endpoint, api_key, timeout, and user-agent.}
}
\value{
A list of gene search results aggregated from all retrieved pages.
}
\description{
This function iteratively calls the \code{gene_search} function to retrieve all available
search results across pages for a given query.
}
\examples{
\donttest{
all_gene_results <- fetch_all_gene_search_results(
  queryFields = list(c("symbol")),
  queryValues = c("A1CF", "A2M", "A4GALT", "A4GNT"),
  fieldsFilter = c("geneID", "symbol", "crossReference.enseGeneID", 
                     "ontology.id", "ontology.term", "ontology.cat"),
  searchType = "or",
  orderBy = "geneID",
  sortDirection = "asc",
  responseType = "json",
  matchType = "exact",
  organismType = list(c(9606)),
  ontologyCategories = list(),
  limit = 5
)
}
}
