% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{rlaplace_truncated_centered}
\alias{rlaplace_truncated_centered}
\title{Generates centered laplace variables with scale 1.}
\usage{
rlaplace_truncated_centered(n, lo, hi)
}
\arguments{
\item{n}{An integer, the number of samples to return.}

\item{lo}{A double, the lower limit of the distribution.}

\item{hi}{A double, the upper limit of the distribution.}
}
\value{
\code{n} random variables from the truncated laplace distribution.
}
\description{
Generates centered laplace variables with scale 1.
}
\details{
Returns \code{n} random variables from the truncated laplace distribution with density proportional to \eqn{\exp(-|x|)}{exp(-|x|)} on \code{[lo,hi]}.
}
\examples{
hist(rlaplace_truncated_centered(1e4, -Inf, Inf), breaks=200)
hist(rlaplace_truncated_centered(1e4, 0, Inf), breaks=200)
hist(rlaplace_truncated_centered(1e4, 10, 12), breaks=200)
hist(rlaplace_truncated_centered(1e4, -2, 2), breaks=200)
hist(rlaplace_truncated_centered(1e4, -10, 0), breaks=200)
hist(rlaplace_truncated_centered(1e4, -100, Inf), breaks=200)
hist(rlaplace_truncated_centered(1e4, -100, -95), breaks=200)
}
