% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{interval_union}
\alias{interval_union}
\title{Finds the union betweeen two unions of intervals.}
\usage{
interval_union(A, B)
}
\arguments{
\item{A}{A list of vectors of size 2, each representing an interval. It is required that \code{A[[i]][1] <= A[[i]][2] <= A[[j]][1]} for any \code{i < j}.}

\item{B}{A list of vectors of size 2, each representing an interval. It is required that \code{A[[i]][1] <= A[[i]][2] <= A[[j]][1]} for any \code{i < j}.}
}
\value{
A list of vectors of size 2, whose union represents the union between \code{A} and \code{B}.
}
\description{
Finds the union betweeen two unions of intervals.
}
\details{
Finds the union between the union of all intervals in \code{A} and the union of all intervals in \code{B}.
}
\examples{
interval_union(list(c(1.2,1.5), c(2.3,2.7)),
       list(c(0.6,1.4), c(2.5,3.6), c(6.3,6.9)))
interval_union(list(c(-0.3,0.55), c(2.35,2.8)),
       list(c(0.54,0.62), c(2.5,2.9)))
interval_union(list(c(0,1)), list(c(1,2)))
interval_union(list(c(0,1-1e-8)), list(c(1,2)))
interval_union(list(c(0,1), c(2,3)),
       list(c(1,2)))
interval_union(list(c(0,1-1e-8), c(2+1e-8,3)),
       list(c(1,2)))
interval_union(list(c(0,1)), list())
}
