% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{get_elts_trun_gauss}
\alias{get_elts_trun_gauss}
\title{The R implementation to get the elements necessary for calculations for the gaussian setting (a=1, b=1) on domains other than R^p.}
\usage{
get_elts_trun_gauss(
  hdx,
  hpdx,
  x,
  centered = TRUE,
  profiled_if_noncenter = TRUE,
  scale = "",
  diagonal_multiplier = 1
)
}
\arguments{
\item{hdx}{A matrix, \eqn{h(\mathbf{x})}{h(x)} applied to the distance of x from the boundary of the domain, should be of the same dimension as \code{x}.}

\item{hpdx}{A matrix, \eqn{h'(\mathbf{x})}{h\'(x)} applied to the distance of x from the boundary of the domain, should be of the same dimension as \code{x}.}

\item{x}{An \code{n} by \code{p} matrix, the data matrix, where \code{n} is the sample size and \code{p} the dimension.}

\item{centered}{A boolean, whether in the centered setting (assume \eqn{\boldsymbol{\mu}=\boldsymbol{\eta}=0}{\mu=\eta=0}) or not. Default to \code{TRUE}.}

\item{profiled_if_noncenter}{A boolean, whether in the profiled setting (\eqn{\lambda_{\boldsymbol{\eta}}=0}{\lambda_\eta=0}) if noncentered. Parameter ignored if centered=TRUE. Default to \code{TRUE}.}

\item{scale}{A string indicating the scaling method. Returned without being checked or used in the function body. Default to \code{"norm"}.}

\item{diagonal_multiplier}{A number >= 1, the diagonal multiplier.}
}
\value{
A list that contains the elements necessary for estimation.
  \item{n}{The sample size.}
  \item{p}{The dimension.}
  \item{centered}{The centered setting or not. Same as input.}
  \item{scale}{The scaling method. Same as input.}
  \item{diagonal_multiplier}{The diagonal multiplier. Same as input.}
  \item{diagonals_with_multiplier}{A vector that contains the diagonal entries of \eqn{\boldsymbol{\Gamma}}{\Gamma} after applying the multiplier.}
  \item{setting}{The setting \code{"gaussian"}.}
  \item{g_K}{The \eqn{\boldsymbol{g}}{g} vector. In the non-profiled non-centered setting, this is the \eqn{\boldsymbol{g}}{g} sub-vector corresponding to \eqn{\mathbf{K}}{K}.}
  \item{Gamma_K}{The \eqn{\boldsymbol{\Gamma}}{\Gamma} matrix with no diagonal multiplier. In the non-profiled non-centered setting, this is the \eqn{\boldsymbol{\Gamma}}{\Gamma} sub-matrix corresponding to \eqn{\mathbf{K}}{K}.}
  \item{g_eta}{Returned in the non-profiled non-centered setting. The \eqn{\boldsymbol{g}}{g} sub-vector corresponding to \eqn{\boldsymbol{\eta}}{\eta}.}
  \item{Gamma_K_eta}{Returned in the non-profiled non-centered setting. The \eqn{\boldsymbol{\Gamma}}{\Gamma} sub-matrix corresponding to interaction between \eqn{\mathbf{K}}{K} and \eqn{\boldsymbol{\eta}}{\eta}.}
  \item{Gamma_eta}{Returned in the non-profiled non-centered setting. The \eqn{\boldsymbol{\Gamma}}{\Gamma} sub-matrix corresponding to \eqn{\boldsymbol{\eta}}{\eta}.}
  \item{t1,t2}{Returned in the profiled non-centered setting, where the \eqn{\boldsymbol{\eta}}{\eta} estimate can be retrieved from \eqn{\boldsymbol{t_1}-\boldsymbol{t_2}\hat{\mathbf{K}}}{t1-t2*\hat{K}} after appropriate resizing.}
}
\description{
The R implementation to get the elements necessary for calculations for the gaussian setting (a=1, b=1) on domains other than R^p.
}
\details{
For details on the returned values, please refer to \code{get_elts_ab} or \code{get_elts}.
}
\examples{
n <- 50
p <- 30
mu <- rep(0, p)
K <- diag(p)
eta <- K \%*\% mu
domain <- make_domain("R+", p=p)
x <- gen(n, setting="gaussian", abs=FALSE, eta=eta, K=K, domain=domain,
       finite_infinity=100, xinit=NULL, seed=2, burn_in=1000, thinning=100)
h_hp <- get_h_hp("min_pow", 1, 3)
h_hp_dx <- h_of_dist(h_hp, x, domain) # h and h' applied to distance from x to boundary
get_elts_trun_gauss(h_hp_dx$hdx, h_hp_dx$hpdx, x, centered=TRUE, scale="norm", diag=1.5)
get_elts_trun_gauss(h_hp_dx$hdx, h_hp_dx$hpdx, x, centered=FALSE,
       profiled_if_noncenter=TRUE, scale="norm", diag=1.7)
get_elts_trun_gauss(h_hp_dx$hdx, h_hp_dx$hpdx, x, centered=FALSE,
       profiled_if_noncenter=FALSE, scale="norm", diag=1.9)
}
