% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcorHijk.R
\name{parcorHijk}
\alias{parcorHijk}
\title{Generalized partial correlation coefficients between Xi and Xj, after removing the
effect of Xk, via OLS regression residuals.}
\usage{
parcorHijk(xi, xj, xk)
}
\arguments{
\item{xi}{{Input vector of data for variable xi}}

\item{xj}{{Input vector of data for variable xj}}

\item{xk}{{Input data for all variables in xk, usually control variables}}
}
\value{
\item{ouij}{Generalized partial correlation Xi with Xj (=cause) after removing xk}
\item{ouji}{Generalized partial correlation Xj with Xi (=cause) after removing xk}
allowing for control variables.
}
\description{
This function uses data on two column vectors, xi, xj, and a third set
xk, which can be a vector or a matrix. xk usually has the remaining 
variables in the model, including control variables, if any. This function
first removes missing data from all input variables. Then,
it computes residuals of OLS (no kernel) regression (xi on xk) and (xj on xk). 
This hybrid version uses both OLS and then generalized correlation among
OLS residuals. This solves the potential problem of having too little
information content in kernel regression residuals, since kernel fits are
sometimes too close, especially when there are many variables in xk.
}
\note{
This function calls \code{\link{kern}},
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
options(np.messages=FALSE)
parcorHijk(x[,1], x[,2], x[,3])
}#' 
}
\seealso{
See  \code{\link{parcor_ijk}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
