% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naTriple.R
\name{naTriple}
\alias{naTriple}
\title{Function to do matched deletion of missing rows from x, y 
and z variable(s).}
\usage{
naTriple(x, y, z)
}
\arguments{
\item{x}{Vector of x data}

\item{y}{Vector of y data}

\item{z}{vector or a matrix of additional variable(s)}
}
\value{
\item{newx}{A new vector x after removing triplet-wise missing data} 
\item{newy}{A new vector or matrix y after removing triplet-wise missing data} 
\item{newz}{A new vector or matrix ctrl after removing triplet-wise missing data}
}
\description{
The aim in three-way deletions is to retain only the largest 
number of available data triplets with all non-missing data.
This works where naTriplet fails (e.g.parcorVecH()). This is
called by parcorHijk
}
\examples{

\dontrun{
x=sample(1:10);y=sample(1:10);x[2]=NA; y[3]=NA
w=sample(2:11)
naTriple(x,y,w)}

}
\seealso{
See \code{\link{napair}} \code{\link{naTriplet}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
