% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absBstdresC.R
\name{absBstdresC}
\alias{absBstdresC}
\title{Block version of Absolute values of residuals of kernel regressions of standardized x on 
standardized y and control variables.}
\usage{
absBstdresC(x, y, ctrl, blksiz = 10)
}
\arguments{
\item{x}{{vector of data on the dependent variable}}

\item{y}{{data on the regressors which can be a matrix}}

\item{ctrl}{{Data matrix on the control variable(s) beyond causal path issues}}

\item{blksiz}{{block size, default=10, if chosen blksiz >n, where n=rows in matrix
then blksiz=n. That is, no blocking is done}}
}
\value{
Absolute values of kernel regression residuals are returned after
standardizing the data on both sides so that the magnitudes of residuals are
comparable between regression of x on y on the one hand and regression of y
on x on the other.
}
\description{
1) standardize the data to force mean zero and variance unity, 2) kernel
regress x on y and a matrix of control variables, 
with the option `residuals = TRUE' and finally 3) compute
the absolute values of residuals.
}
\details{
The first argument is assumed to be the dependent variable.  If
\code{abs_stdres(x,y)} is used, you are regressing x on y (not the usual y
on x). The regressors can be a matrix with two or more columns. The missing values
are suitably ignored by the standardization.
}
\examples{

\dontrun{
set.seed(330)
x=sample(20:50)
y=sample(20:50)
z=sample(21:51)
absBstdresC(x,y,ctrl=z)
}

}
\references{
Vinod, H. D.'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \doi{gffn86}
}
\seealso{
See  \code{\link{abs_stdres}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{kernel regression residuals}
