% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcorSilent.R
\name{parcorSilent}
\alias{parcorSilent}
\title{Silently compute generalized (ridge-adjusted) partial correlation coefficients from matrix R*.}
\usage{
parcorSilent(gmc0, dig = 4, idep = 1, verbo = FALSE, incr = 3)
}
\arguments{
\item{gmc0}{This must be a p by p matrix R* of generalized correlation coefficients.}

\item{dig}{The number of digits for reporting (=4, default)}

\item{idep}{The column number of the first variable (=1, default)}

\item{verbo}{Make this TRUE for detailed printing of computational steps}

\item{incr}{{incremental constant for iteratively adjusting `ridgek'
      where ridgek is the constant times the identity matrix used to
  make sure that the gmc0 matrix is positive definite. If not, this function iteratively
increases the \code{incr} till relevant partial correlations are within the [-1,1] interval.}}
}
\value{
A five column `out' matrix containing partials. The first column
  has the name of the \code{idep} variable. The
   second column has the name of the j variable, while the third column has  r*(i,j | k).
  The 4-th column has  r*(j,i | k) (denoted partji), and the 5-th column has rijMrji,
  that is the difference in absolute values (abs(partij) - abs(partji)).
}
\description{
This function calls \code{parcor_ijkOLD} function which
uses a generalized correlation matrix R* as input to compute
generalized partial correlations between \eqn{X_i} and \eqn{X_j}
where j can be any one of the remaining
variables. Computation removes the effect of all other variables in the matrix.
It further adjusts the resulting partial correlation coefficients to be in the
appropriate [-1,1] range by using an additive constant in the fashion of ridge regression.
}
\note{
The ridgek constant created by the function during the first round
 may not be large enough to make sure that
 that other pairs of r*(i,j | k) are within the [-1,1] interval. The user may have to choose
 a suitably larger input \code{incr} to get all relevant partial
 correlation coefficients in  the correct [-1,1] interval.
}
\examples{
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is partly indep and partly affected by z
y=1+2*x+3*z+rnorm(10)# y depends on x and z not vice versa
mtx=cbind(x,y,z)
g1=gmcmtx0(mtx)
parcor_ijkOLD(g1,1,2) # ouji> ouij implies i=x is the cause of j=y
parcor_ridg(g1,idep=1)
parcorSilent(g1,idep=1)
 
   
\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
gm1=gmcmtx0(x)
parcorSilent(gm1, idep=1)
}

}
\references{
Vinod, H. D. 'Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark,' (March 8, 2015)
 \url{https://www.ssrn.com/abstract=2574891}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
 Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.

Vinod, H. D. "A Survey of Ridge Regression and Related Techniques 
for Improvements over Ordinary Least Squares," Review of Economics and Statistics, 
Vol. 60, February 1978, pp. 121-131.
}
\seealso{
See Also \code{\link{parcor_ijk}} for a better version using original data as input.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{partial correlations}
\concept{ridge biasing factor}
