% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLhat.R
\name{NLhat}
\alias{NLhat}
\title{Compute fitted values from kernel regression of x on y and y on x}
\usage{
NLhat(x, y)
}
\arguments{
\item{x}{{A column vector of x data}}

\item{y}{{A column vector of y data}}
}
\value{
{two vectors named xhat and yhat for fitted values}
}
\description{
This is an auxiliary function for `gmcmtxBlk.' It uses 
two numerical vectors (x, y) of same length to create two vectors
(xhat, yhat) of fitted values using nonlinear kernel regressions.
It
uses package `np' called by 
\code{kern} function to kernel regress x on y, and conversely y on x. 
It uses the option `residuals=TRUE' of `kern'
}
\examples{


\dontrun{
set.seed(34);x=sample(1:15);y=sample(1:15)
NLhat(x,y)}

}
\seealso{
See Also as \code{\link{gmcmtxBlk}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
