% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causeSummBlk.R
\name{causeSummBlk}
\alias{causeSummBlk}
\title{Block Version Kernel causality summary causal paths from three criteria}
\usage{
causeSummBlk(
  mtx,
  nam = colnames(mtx),
  blksiz = 10,
  ctrl = 0,
  dig = 6,
  wt = c(1.2, 1.1, 1.05, 1),
  sumwt = 4
)
}
\arguments{
\item{mtx}{{The data matrix with many columns, y the first column 
is a fixed target and then it is
 paired with all other columns, one by one, and still called x for the 
 purpose of flipping.}}

\item{nam}{{vector of column names for \code{mtx}. Default: colnames(mtx)}}

\item{blksiz}{{block size, default=10, if chosen blksiz >n, where n=rows in matrix
then blksiz=n. That is, no blocking is done}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{wt}{{Allows user to choose a vector of four alternative weights for SD1 to SD4.}}

\item{sumwt}{{ Sum of weights can be changed here =4(default).}}
}
\value{
If there are p columns in the input matrix, x1, x2, .., xp, say,
and if we keep x1 as a common member of all causal-direction-pairs
(x1, x(1+j)) for (j=1, 2, .., p-1) which can be flipped. That is, either x1 is
the cause or x(1+j) is the cause in a chosen pair.
The control
variables are not flipped. The printed output of this function
reports the results for p-1 pairs indicating which variable
(by name) causes which other variable (also by name).
It also prints strength or signed summary strength index in range [-100,100]. 
A positive sign of the strength index means x1 kernel causes x(1+j),
whereas negative strength index means x(1+j) kernel causes x1. The function 
also prints Pearson correlation and its p-value. This function also returns
a matrix of p-1 rows and 5 columns entitled: 
``cause", ``response", ``strength", ``corr." and ``p-value", respectively
with self-explanatory titles. The first two columns have names of variables
x1 or x(1+j), depending on which is the cause. The `strength' column
has absolute value of summary index in range [0,100]  
providing summary of causal results
based on preponderance of evidence from Cr1 to Cr3 
from four orders of stochastic dominance, etc.  The order of input columns matters.
The fourth column `corr.' reports the Pearson correlation coefficient while
the fifth column has the p-value for testing the null of zero Pearson coeff.
This function calls  \code{siPairsBlk} allowing for control variables.
The output of this function can be sent to `xtable' for a nice Latex table.
}
\description{
Allowing input matrix of control variables, this function produces 
a 5 column matrix
summarizing the results where the estimated signs of
stochastic dominance order values, (+1, 0, -1), are weighted by 
 \code{wt=c(1.2,1.1, 1.05, 1)} to
compute an overall result for all orders of stochastic dominance by 
a weighted sum for
the criteria Cr1 and Cr2 and added to the Cr3 estimate as: (+1, 0, -1).
The final range for the unanimity of sign index is [--100, 100].
}
\details{
The reason for slightly declining weights on the signs from
SD1 to SD4 is simply that the local mean comparisons 
implicit in SD1 are known to be
more reliable than local variance implicit in SD2, local skewness implicit in
SD3 and local kurtosis implicit in SD4. The reason for 
slightly declining sampling
unreliability of higher moments is simply that SD4 involves fourth power
of the deviations from the mean and SD3 involves 3rd power, etc.
The summary results for all
three criteria are reported in one matrix called \code{out}:
}
\note{
The European Crime data has all three criteria correctly suggesting that
high crime rate kernel causes the deployment of a large number of police officers.
Since Cr1 to Cr3 near unanimously suggest `crim' as the cause of `off', 
strength index 100 suggests unanimity. 
\code{attach(EuroCrime); causeSummary(cbind(crim,off))}
}
\examples{


\dontrun{
mtx=as.matrix(mtcars[,1:3])
ctrl=as.matrix(mtcars[,4:5])
 causeSummBlk(mtx,ctrl,nam=colnames(mtx))
}

options(np.messages=FALSE)
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10 #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
causeSummBlk(mtx=cbind(x2,y2), ctrl=cbind(z,w2))


}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \url{https://doi.org/gffn86}

Vinod, H. D. 'New exogeneity tests and causal paths,'
 Chapter 2 in 'Handbook of Statistics: Conceptual Econometrics 
Using R', Vol.32, co-editors: H. D. Vinod and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2019, pp. 33-64.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: 
\url{https://www.ssrn.com/abstract=2982128}
}
\seealso{
See  \code{\link{bootPairs}},  \code{\link{causeSummary0}} has
an older version of this function.

See  \code{\link{someCPairs}}

\code{\link{siPairsBlk}}, \code{\link{causeSummary}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{causal path}
\concept{stochastic dominance orders}
\concept{summary index}
