% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_correction_function.R
\name{errorCorrection_multiple}
\alias{errorCorrection_multiple}
\title{Error Correction for multiple objects}
\usage{
errorCorrection_multiple(BC_dat, maxDist, save_it = FALSE, cpus = 1,
  m = "hamming")
}
\arguments{
\item{BC_dat}{a BCdat object, containing the necessary sequences.}

\item{maxDist}{an integer value representing the maximal (hamming) distance for which it is allowed to
cluster two sequences together.}

\item{save_it}{a logical value. If TRUE the data will be saved as csv-file.}

\item{cpus}{an integer value, in case multiple BCdat objects are provided a CPU number greater than one
would allow for a parallelized calculation (one CPU per BCdat object).}

\item{m}{a character string. Method for distance calculation, default is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information)}
}
\value{
a list of BCdat objects.
}
\description{
Corrects a list of equally long (barcode) sequences. Based on calculated hamming distances
as a measure of similarity, highly similar sequences are clustered together and the cluster label will
be the respective sequence with the highest read count.
}
