`fit.continuous` <-
function(tips, phy, lambda=FALSE, kappa=FALSE, delta=FALSE, alpha=FALSE, bounds=NULL,log=FALSE, print=TRUE)
{

	phy2<-phy
	phy<-new2old.phylo(phy)
	
    if (!is.vector(tips))
    	stop("Currently only one set of TIP values can be analysed")
    if (is.null(names(tips)))
    	stop("the variable \"tips\" must have names specified for elements, use \"names()\" function or see help")
    #--------------------------------
    #---    CALCULATIONS       ---
    #--------------------------------	
 	if(log==TRUE){tips<- log(tips)}
 	vcv 	    <- vcv.phylo(phy2, mode="Brownian") # Variance - Covariance Matrix
 	tree.matrix <- get.simulation.matrix(phy)
 	if(nrow(vcv)!=length(tips))
 		stop("Object \"tips\" and object \"phy\" are not of the same length")
	#--------------------------------
    #---     SORT TIP DATA        ---
    #--------------------------------
    spp.dat <- names(tips)
    spp.vcv <- rownames(vcv)
    n <- length(tips)
    if (sum(spp.dat == spp.vcv) != length(spp.vcv)){
    	#warning("TIP data was sorted to match tree")
        index <- numeric()              
        for (i in 1:n){
            index[i] <- (1:n)[spp.vcv[i] == spp.dat]
        }
        if(sum(is.na(index)) > 0)
        	stop("Cannot match object \"tips\" to object \"phy\", species names do not match")
    	tips <- tips[index]
    }
    spp.dat <- names(tips)
    spp.vcv <- rownames(vcv)
    if (sum(spp.dat == spp.vcv) != length(spp.vcv))
    	stop("Cannot match object \"tips\" to object \"phy\"")
	#--------------------------------
    #---    PREPARE DATA LIST     ---
    #--------------------------------
	data			<- list()
   		data$obs 		<- tips          # TIP data 
    	data$spp.name	<- names(tips)	 # SPP Names of TIP data
    	data$vcv 		<- vcv
  		data$tree.matrix<- tree.matrix
    #--------------------------------
    #--- SET MODEL SPECIFICATIONS ---
    #--------------------------------
    model<-c(lambda, kappa, delta, alpha)
	names(model)<- c("lambda", "kappa", "delta", "alpha")
	if (sum(model) > 1)
		stop("Currently, lambda, kappa, delta, and alpha can only be fit one at a time")
    #-----------------------------
    #---  SET PARAMETER BOUNDS ---
    #-----------------------------
    #---- DEFAULT BOUNDS
    bounds.default			 <- matrix(c(0.00001, 20, 0,1, 0.000001, 5, 0, 12, 0, 5), nrow=5, ncol=2, byrow=TRUE)
    rownames(bounds.default) <- c("beta", "lambda", "kappa", "delta", "alpha");
    colnames(bounds.default) <- c("min", "max")

 	#---- USER DEFINED PARAMETER BOUNDS
 	if (is.null(bounds)) {
 		bounds <- bounds.default       # USE DEFAULTS
 	}else{
 		if (class(bounds)!="list"){
 			stop("Please specify user defined parameter bounds as a list()")
 		}else{
 			specified   <- !c(is.null(bounds$beta), is.null(bounds$lambda), 
 							  is.null(bounds$kappa), is.null(bounds$delta),  is.null(bounds$alpha)
 							  )
 			bounds.user <- matrix(c(bounds$beta, bounds$lambda, bounds$kappa, bounds$delta, bounds$alpha), 
 								  nrow=sum(specified), ncol=2, byrow=TRUE
 								  )
 			rownames(bounds.user) <- c("beta", "lambda", "kappa", "delta", "alpha")[specified]
   	 		colnames(bounds.user) <- c("min", "max")
   	 		#----  NOTIFICATION
   	 		print("Warning: The following user defined parameter bounds have been set:", quote=FALSE)
   	 		print(bounds.user)
   	 		#----  SET FINAL SEARCH BOUNDS
 			bounds <- bounds.default
 			bounds[specified,] <- bounds.user     # Final Bounds
   		} # END if list
   	}  # END user bound if loop
   	#--------------------------------
    #---   APPEND MODEL SETTINGS  ---
    #--------------------------------
  	data$design$bounds <- data.frame(t(bounds))
  	data$design$model  <- model
  	#--------------------------------
    #---        FIT MODEL         ---
    #--------------------------------
  	fit.pagel(data, print=print)
}

