% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spade.R
\name{spade}
\alias{spade}
\title{spatial association detector (SPADE) model}
\usage{
spade(
  formula,
  data,
  wt = NULL,
  locations = NULL,
  discnum = NULL,
  discmethod = NULL,
  cores = 1,
  seed = 123456789,
  permutations = 0,
  ...
)
}
\arguments{
\item{formula}{A formula of spatial association detector (SPADE) model.}

\item{data}{A data.frame or tibble of observation data.}

\item{wt}{(optional) The spatial weight matrix. When \code{wt} is not provided, must provide \code{locations}.
And \code{gdverse} will use \code{locations} columns to construct spatial weight use \code{inverse_distance_weight()}.}

\item{locations}{(optional) The spatial location coordinates columns name in \code{data}.
Useful and must provided when \code{wt} is not provided. When \code{wt} is provided, \code{locations} is not need.}

\item{discnum}{(optional) Number of multilevel discretization. Default will use \code{3:22}.}

\item{discmethod}{(optional) The discretization methods. Default all use \code{quantile}.
Noted that \code{robust} will use \code{robust_disc()}; \code{rpart} will use \code{rpart_disc()};
Others use \code{st_unidisc()}.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use parallel computation.}

\item{seed}{(optional) Random number seed, default is \code{123456789}.}

\item{permutations}{(optional) The number of permutations for the PSD computation. Default is \code{0},
which means no pseudo-p values are calculated.}

\item{...}{(optional) Other arguments passed to \code{st_unidisc()},\code{robust_disc()} or \code{rpart_disc()}.}
}
\value{
A list of the SPADE model result.
\describe{
\item{\code{factor}}{the result of SPADE model}
}
}
\description{
Function for spatial association detector (SPADE) model.
}
\note{
The columns in the \code{locations} part of data are only used to construct spatial weight matrix
when \code{wt} is \code{NULL}, and are not considered as explanatory variables. If you need to include
spatial locations as explanatory variables, build a spatial weight matrix ahead of time,
leaving the \code{locations} parameter to \code{NULL}.The most recommended method is to explicitly
specify all variables in \code{formula} instead of using \code{.}!
}
\examples{
data('sim')
g = spade(y ~ ., data = sim,
          locations = c('lo','la'),
          discvar = c("xa","xb","xc"))
g

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
