% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{gd_bestunidisc}
\alias{gd_bestunidisc}
\title{best univariate discretization based on geodetector q-statistic}
\usage{
gd_bestunidisc(
  formula,
  data,
  discnum = NULL,
  discmethod = NULL,
  cores = 1,
  return_disc = TRUE,
  seed = 123456789,
  ...
)
}
\arguments{
\item{formula}{A formula of best univariate discretization.}

\item{data}{A data.frame or tibble of observation data.}

\item{discnum}{(optional) A vector of number of classes for discretization. Default is \code{3:22}.}

\item{discmethod}{(optional) A vector of methods for discretization,default is using
\code{c("sd","equal","pretty","quantile","fisher","headtails","maximum","box")}in \code{gdverse}.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, a 'parallel' package
cluster with that many cores is created and used. You can also supply a cluster
object.}

\item{return_disc}{(optional) Whether or not return discretized result used the optimal parameter.
Default is \code{TRUE}.}

\item{seed}{(optional) Random seed number, default is \code{123456789}. Setting random seed is useful when
the sample size is greater than \code{3000}(the default value for \code{largeN}) and the data is discretized
by sampling \verb{10\%}(the default value for \code{samp_prop} in \code{st_unidisc()}).}

\item{...}{(optional) Other arguments passed to \code{st_unidisc()}.}
}
\value{
A list with the optimal parameter in the provided parameter combination with \code{k},
\code{method} and \code{disc}(when \code{return_disc} is \code{TRUE}).
\describe{
\item{\code{x}}{the name of the variable that needs to be discretized}
\item{\code{k}}{optimal discretization number}
\item{\code{method}}{optimal discretization method}
\item{\code{disc}}{optimal discretization results}
}
}
\description{
Function for determining the best univariate discretization based on geodetector q-statistic.
}
\examples{
data('sim')
gd_bestunidisc(y ~ xa + xb + xc, data = sim,
               discvar = paste0('x',letters[1:3]),
               discnum = 3:6)

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
