\name{simulglyph.vmf}
\alias{simulglyph.vmf}
\concept{Simulation}
\concept{ODF visualization}
\concept{Glyph mapping}
\title{Voxel Diffusion Profile Simulation and von Mises-Fisher Fibre Mapping}
\description{
The synthesized diffusion voxel profiles generated by \code{synthfiberss2z} are used to reconstruct ODF profiles.
Three methods may be used for reconstruction: GQI, GQI2, and Q-ball.
ODF profiles and fibre directions are estimated by relying on von Mises-Fisher (vMF) distributions for directional mapping. 
}

\usage{
simulglyph.vmf(gdi="gqi", s2grid=NULL, angles=c(20,100), depth=3, b=3000,
 lambda=NULL, order=4, sigma=NULL, threshold=0.4, snapshot=FALSE,
 savedir=tempdir(), pngfig="glyph1", showglyph=TRUE, aniso=NULL,
 logplot=TRUE, wi=c(0.5,0.5))
}

\arguments{
\item{gdi}{ method of ODF reconstruction to use \code{c("gqi", "gqi2", "sph")} (default: \code{"gqi"}). }
\item{s2grid}{ S2 shell grid, or other equivalent user specified grid. By default \code{s2grid=NULL} means
 that the grid is generated by \code{s2tessel.zorder}. }
\item{angles}{ angles in degrees of fibres to be used in simulation (default: two fibres with angles \code{c(20,100)}). }
\item{depth}{ sampling densities on the hemisphere used in simulation (default N=321; depth=3). }
\item{b}{ strength of the magnetic diffusion gradient (default b-value=3000). }
\item{lambda}{ model parameter:  diffusion sampling length in \code{gdi="gqi"} and \code{gdi="gqi2"};
 Aganj's regularization parameter in \code{gdi="sph"}. By default the following default values are used when
 \code{lambda=NULL} is specified: 1.24 in "gqi", 3 in "gqi2", and 0.006 in "sph". }
\item{order}{ parameter associated with the oder of the order of the spherical harmonics approximation (default: 4). }
\item{sigma}{ Rician noise level used in simulation; (default \code{NULL}). }
\item{threshold}{ thresholding generalized fractional anisotropy (GFA) value at each voxel (default: 0.4). }
\item{snapshot}{ logical variable controlling line-map snapshots (default: \code{FALSE}). }
\item{savedir}{ directory for saving/loading processed results (default: \code{tempdir()}). }
\item{pngfig}{ base-name of the PNG files when \code{snapshot} is \code{TRUE} (default \code{"glyph1"}). }
\item{showglyph}{ logical variable controlling visualization of voxel glyphs (default: \code{TRUE}). }
\item{aniso}{ anisotropic parameter to use in ODF visualization in the range "[0,1)" or \code{NULL}. }
\item{logplot}{ logical variable for selecting log-scale (default \code{TRUE}). }
\item{wi}{ weight given to fiber's volume fraction (default for two fibers \code{c(0.5,0.5)}). }
}

\value{
\code{simulglyph.vmf} plots the reconstructed ODF profile together with the vMF-estimated fiber directions.
}

\details{
The "gdi" argument specifies the method of ODF reconstruction to use in the list \code{c("gqi", "gqi2", "sph")}.
The number of fibres is automatically estimated from the diffusion profile.
To decide on the number of components to select the Bayesian information criterion (BIC) is applied. 
}

\references{
Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Hornik, K., and Gruen, B. \pkg{movMF}: Mixtures of von Mises-Fisher Distributions, 2012. R package version 0.0-2.

Adler, D., and Murdoch, D. \pkg{rgl}: 3D visualization device system (OpenGL), 2012. R package version 0.92.880.

Barber, C. B., Habel, K., Grasman, R., Gramacy, R. B., Stahel, A., and Sterratt, D. C. \pkg{geometry}: Mesh generation and surface tessellation, 2012. R package version 0.3-2.

Tabelow K., Polzehl J.: \pkg{dti}: DTI/DWI Analysis, 2012. R package version 1.1-0.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{synthfiberss2z}},
  \code{\link{plotglyph}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{rgbvolmap}},
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfpeaklines}},
  \code{\link{gqi.odfvxgrid}},
  \code{\link{simul.fandtasia}},
  \code{\link{simul.simplefield}}
}

\examples{
\dontrun{
    ## Examples of synthetized voxel diffusion glyphs
    ## ODF glyphs, and vMF fiber orientation mapping 
    ## noise-free simulations and vMF estimation by GQI and QBI
    b <- 3000; angles <- c(20,110)
    simulglyph.vmf(angles=angles,b=b, gdi="gqi")
    simulglyph.vmf(angles=angles,b=b, gdi="gqi", logplot=FALSE)
    simulglyph.vmf(angles=angles,b=b, gdi="gqi2")
    simulglyph.vmf(angles=angles,b=b, gdi="gqi2", logplot=FALSE)
    simulglyph.vmf(angles=angles,b=b, gdi="gqi", aniso=0.5)
    simulglyph.vmf(angles=angles,b=b, gdi="sph")
    simulglyph.vmf(angles=angles,b=b, gdi="sph", aniso=0.5)
    ## plot diffusion signal with "logplot=FALSE"
    angles <- 45; b <- 1500
    simulglyph.vmf(angles=angles,b=b, gdi="gqi",  logplot=FALSE)
    simulglyph.vmf(angles=angles,b=b, gdi="gqi2", logplot=FALSE)
    ## 2 direction, lower crossing-angles, higher b
    angles <- c(20,80); b <- 6000
    simulglyph.vmf(angles=angles,b=b, gdi="gqi")
    simulglyph.vmf(angles=angles,b=b, gdi="sph")
    ## 2 direction, different volume fractions
    simulglyph.vmf(angles=angles, b=b, wi=c(0.7, 0.3))
    ## 2 direction, low croosing angle
    angles <- c(20,65); b <- 6000
    simulglyph.vmf(angles=angles,b=b)
    ## 3 directions
    angles <- c(20,80,140)
    simulglyph.vmf(angles=angles,b=b)
    # 3 directions
    angles <- c(0,60,120)
    simulglyph.vmf(angles=angles,b=b)
    ##------------------
    ## noisy simulations and vMF estimation by GQI and QBI
    b <- 3000; sigma <- 0.033
    angles <- c(20,110)
    simulglyph.vmf(angles=angles,b=b, sigma=sigma, gdi="gqi")
    simulglyph.vmf(angles=angles,b=b, sigma=sigma, gdi="sph")
    # 2 direction, lower crossing-angles, higher b
    angles <- c(20,80)
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    ## 2 direction, low croosing angle
    angles <- c(20,65)
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    # 3 directions
    angles <- c(20,80,140)
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    # 3 directions
    angles <- c(0,60,120)
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
}
}

\keyword{ utilities }

