% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{createCopy}
\alias{createCopy}
\title{Create a copy of a raster}
\usage{
createCopy(format, dst_filename, src_filename, strict = FALSE, options = NULL)
}
\arguments{
\item{format}{Format short name for the output raster
(e.g., "GTiff" or "HFA").}

\item{dst_filename}{Filename to create.}

\item{src_filename}{Filename of source raster.}

\item{strict}{Logical. TRUE if the copy must be strictly equivalent,
or more normally FALSE indicating that the copy may adapt as needed for
the output format.}

\item{options}{Optional list of format-specific creation options in a
vector of \code{"NAME=VALUE"} pairs
(e.g., \code{options = c("COMPRESS=LZW")} to set \code{LZW}
compression during creation of a GTiff file).
The APPEND_SUBDATASET=YES option can be
specified to avoid prior destruction of existing dataset.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{createCopy()} copies a raster dataset, optionally changing the format.
The extent, cell size, number of bands, data type, projection, and
geotransform are all copied from the source raster.
}
\examples{
lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
tif_file <- paste0(tempdir(), "/", "storml_lndscp.tif")
opt <- c("COMPRESS=LZW")
createCopy(format="GTiff", dst_filename=tif_file, src_filename=lcp_file,
           options=opt)
file.size(lcp_file)
file.size(tif_file)
ds <- new(GDALRaster, tif_file, read_only=FALSE)
ds$getMetadata(band=0, domain="IMAGE_STRUCTURE")
for (band in 1:ds$getRasterCount())
    ds$setNoDataValue(band, -9999)
ds$getStatistics(band=1, approx_ok=FALSE, force=TRUE)
ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=rasterFromRaster]{rasterFromRaster()}},
\code{\link[=getCreationOptions]{getCreationOptions()}}, \code{\link[=translate]{translate()}}
}
