% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{srs_is_projected}
\alias{srs_is_projected}
\title{Check if WKT definition is a projected coordinate system}
\usage{
srs_is_projected(srs)
}
\arguments{
\item{srs}{Character OGC WKT string for a spatial reference system}
}
\value{
Logical. \code{TRUE} if \code{srs} is projected, otherwise \code{FALSE}
}
\description{
\code{srs_is_projected()} will attempt to import the given WKT string as a
spatial reference system (SRS), and returns \code{TRUE} if the SRS contains a
PROJCS node indicating a it is a projected coordinate system. This is a
wrapper for \code{OSRIsProjected()} in the GDAL Spatial Reference System C API.
}
\examples{
srs_is_projected(epsg_to_wkt(5070))
srs_is_projected(srs_to_wkt("WGS84"))
}
\seealso{
\code{\link[=srs_is_geographic]{srs_is_geographic()}}, \code{\link[=srs_is_same]{srs_is_same()}}
}
