% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_nist.R
\name{plot_nist}
\alias{plot_nist}
\title{Plots the mass spectra of a NIST compound.}
\usage{
plot_nist(nistlist, k, ms, title = "NIST Mass Spectrum")
}
\arguments{
\item{nistlist}{a \emph{list} object, a list of compound MS data from the
NIST MS Library database, ideally the output of nist_list().}

\item{k}{a \emph{integer} object, the index of the NIST compound in the
nistlist input.}

\item{ms}{a \emph{data.frame} object, a data frame of the mass values and the
percent intensity values, ideally the output of find_ms().}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "Mass Spectrum".}
}
\value{
A \emph{ggplot} object. A line plot of the mass spectra data. The
mass values vs the percent intensity values as a percent of the highest
intensity.
}
\description{
\code{plot_nist} Plots the mass spectra of a NIST compound.
}
\details{
This function produces line plot of the mass spectra data from the
sample on top, and the mass spectrum from a NIST compound entry on the
bottom. The mass values vs the percent intensity values as a percent of the
highest intensity using \code{\link[ggplot2]{ggplot}} from ggplot2 package
\insertCite{ggplot2}{gcxgclab}.
}
\references{
\insertAllCited{}
}
