% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{find_threshold_crosses}
\alias{find_threshold_crosses}
\title{Find all points when a numeric vector crosses some threshold}
\usage{
find_threshold_crosses(
  y,
  x = NULL,
  threshold,
  return = "index",
  return_rising = TRUE,
  return_falling = TRUE,
  return_endpoints = TRUE,
  subset = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{y}{Numeric vector of y values in which to identify threshold
crossing events}

\item{x}{Optional numeric vector of corresponding x values}

\item{threshold}{Threshold y value of interest}

\item{return}{One of \code{c("index", "x")}, determining whether the function
will return the \code{index} or \code{x} value associated with the
threshold-crossing event.

If \code{index}, it will refer to the data point immediately after
the crossing event.

If \code{x}, it will use linear interpolation and the data
points immediately before and after the threshold-crossing
to return the exact \code{x} value when the threshold crossing
occurred}

\item{return_rising}{Boolean for whether crossing events where \code{y}
rises above \code{threshold} should be returned}

\item{return_falling}{Boolean for whether crossing events where \code{y}
falls below \code{threshold} should be returned}

\item{return_endpoints}{Boolean for whether startpoint should be returned
when the startpoint is above \code{threshold} and
\code{return_rising = TRUE}, or when the startpoint is
below \code{threshold} and \code{return_falling = TRUE}}

\item{subset}{A vector of Boolean values indicating which x and y values
should be included (TRUE) or excluded (FALSE).

If \code{return = "index"}, index will be for the whole 
vector and not the subset of the vector}

\item{na.rm}{Boolean whether NA's should be removed before analyzing.
If \code{return = 'index'}, indices will refer to the original
\code{y} vector *including* \code{NA} values}
}
\value{
A vector of indices (\code{return = "index"}) or x values
        (\code{return = "x"}) for when \code{y} crossed \code{threshold}
}
\description{
This function takes a vector of \code{y} values and 
returns the index or x value of every point where the \code{y} values
cross some threshold y value.
}
