% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_distr.R
\name{distr}
\alias{distr}
\title{Get the Table of Supported Distributions}
\usage{
distr(filter_distr = NULL, filter_param = NULL, filter_type = NULL,
  filter_dim = NULL, filter_orthog = NULL, filter_default = NULL)
}
\arguments{
\item{filter_distr}{An optional vector of distributions by which the output is filtered.}

\item{filter_param}{An optional vector of parametrizations by which the output is filtered.}

\item{filter_type}{An optional vector of data types by which the output is filtered.}

\item{filter_dim}{An optional vector of dimensions by which the output is filtered.}

\item{filter_orthog}{An optional logical value indicating whether the parametrization is orthogonal by which the output is filtered.}

\item{filter_default}{An optional logical value indicating whether the parameterization is the default for the distribution by which the output is filtered.}
}
\value{
A \code{data.frame} with columns:
\item{distr_title}{The title of the distribution.}
\item{param_title}{The title of the parametrization.}
\item{distr}{The distribution.}
\item{param}{The parametrization.}
\item{type}{The data type.}
\item{dim}{The dimension.}
\item{orthog}{The indication of whether the parametrization is orthogonal.}
\item{default}{The indication of whether the parameterization is the default for the distribution.}
}
\description{
A function listing distributions and their parametrizations supported by the \code{\link[gasmodel:gas]{gas()}} function.
Output can be filtered using several arguments.
}
\examples{
# List all available distributions
distr()

# List only distributions for count data
distr(filter_type = "count")

# Show default parametrization for the negative binomial distribution
distr(filter_dist = "negbin", filter_default = TRUE)

}
\seealso{
\code{\link[gasmodel:distr_density]{distr_density()}},
\code{\link[gasmodel:distr_mean]{distr_mean()}},
\code{\link[gasmodel:distr_var]{distr_var()}},
\code{\link[gasmodel:distr_score]{distr_score()}},
\code{\link[gasmodel:distr_fisher]{distr_fisher()}},
\code{\link[gasmodel:distr_random]{distr_random()}},
\code{\link[gasmodel:gas]{gas()}}
}
