% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{areduce}
\alias{areduce}
\title{Generalized and smart apply()/Reduce()/tapply() for data folding.}
\usage{
areduce(FUN, X, MARGIN, ..., SIMPLIFY = TRUE, SAFE = FALSE)
}
\arguments{
\item{FUN}{Usually a summary function (like \code{all} and \code{sum}).}

\item{X}{A garray, with margins (names of dimnames) and maybe with sdim.}

\item{MARGIN}{Some margins of X and names of sdim.
MARGIN=character() means to reduce all margins (over no margin).
In such case, areduce() is not needed actually.}

\item{...}{Further arguments to 'FUN', no matching of margins.}

\item{SIMPLIFY}{TRUE - simplifies the result list to vector of atomic
if possible, and triggers warning and not simplifies if impossible;
FALSE - not simplifies for non speed-up function, and issues warning
(and have to simplify) for speed-up function; NA - simplifies but no
warning if impossible.}

\item{SAFE}{TRUE - use safe but slow implementation, in which data splited
from the array are reorganized into small arrays (as are being subset
by \code{[]}) and passed to FUN (other attributes are dropped, however);
FALSE - faster, data are passed to FUN as dimension-less vectors.}
}
\value{
A matrix (similar to return of apply() or tapply()), with the
trailing margins the same as MARGIN, while the leading margins
depend on FUN and SIMPLIFY.  If FUN returns a scalar or SIMPLIFY=FALSE,
then no leading margins.  In MARGIN, subdimension is replaced with superdims.
}
\description{
Generalized and smart apply()/Reduce()/tapply() for data folding.
}
\examples{
a <- garray(matrix(1:24, 4, 6, dimnames=list(X=LETTERS[1:4], 
	Y=letters[1:6])), sdim=list(XX=c(x1=3,x2=1), YY=c(y1=1,y2=2)))
m1 <- areduce("sum", a, c("X"))
m2 <- areduce(`sum`, a, c("X"))
p1 <- areduce("sum", a, c("YY"))
p2 <- areduce(`sum`, a, c("YY"))
q1 <- areduce("sum", a, c("X","YY"))
q2 <- areduce(`sum`, a, c("X","YY"))
r1 <- areduce("sum", a, c("XX","YY"))
r2 <- areduce(`sum`, a, c("XX","YY"))
b <- garray(1:24, c(3,4,2), dimnames=list(X=LETTERS[1:3], 
     Y=letters[1:4],Z=NULL), sdim=list(XX=c(x1=2,x2=1), YY=c(y1=1,y2=1)))
s1 <- areduce("sum", b, c("XX","YY","Z"))
s2 <- areduce(`sum`, b, c("XX","YY","Z"))
t1 <- areduce(`identity`, b, c("XX","YY","Z"), SIMPLIFY=FALSE)
t2 <- areduce("c", b, c("XX","YY","Z"), SIMPLIFY=FALSE)	# not `c`
t3 <- areduce(`identity`, b, c("XX","YY"), SIMPLIFY=FALSE, SAFE=TRUE)
t4 <- areduce(`identity`, b, c("XX","YY"), SIMPLIFY=FALSE, SAFE=FALSE)
}
