% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_byo_oauth2.R
\name{credentials_byo_oauth2}
\alias{credentials_byo_oauth2}
\title{Load a user-provided token}
\usage{
credentials_byo_oauth2(scopes = NULL, token, ...)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/googlescopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email. It is considered a low value scope and
does not appear on the consent screen.}

\item{token}{A token with class \link[httr:Token-class]{Token2.0} or an object of
httr's class \code{request}, i.e. a token that has been prepared with
\code{\link[httr:config]{httr::config()}} and has a \link[httr:Token-class]{Token2.0} in the
\code{auth_token} component.}

\item{...}{Additional arguments passed to all credential functions.}
}
\value{
An \link[httr:Token-class]{Token2.0}.
}
\description{
This function does very little when called directly with a token:
\itemize{
\item If input has class \code{request}, i.e. it is a token that has been prepared
with \code{\link[httr:config]{httr::config()}}, the \code{auth_token} component is extracted. For
example, such input could be produced by \code{googledrive::drive_token()}
or \code{bigrquery::bq_token()}.
\item Checks that the input appears to be a Google OAuth token, based on
the embedded \code{oauth_endpoint}.
\item Refreshes the token, if it's refreshable.
\item Returns its input.
}

There is no point providing \code{scopes}. They are ignored because the \code{scopes}
associated with the token have already been baked in to the token itself and
gargle does not support incremental authorization. The main point of
\code{credentials_byo_oauth2()} is to allow \code{token_fetch()} (and packages that
wrap it) to accommodate a "bring your own token" workflow.

This also makes it possible to obtain a token with one package and then
register it for use with another package. For example, the default scope
requested by googledrive is also sufficient for operations available in
googlesheets4. You could use a shared token like so:\preformatted{library(googledrive)
library(googlesheets4)
drive_auth(email = "jane_doe@example.com")
sheets_auth(token = drive_token())
# work with both packages freely now
}
}
\examples{
\dontrun{
# assume `my_token` is a Token2.0 object returned by a function such as
# httr::oauth2.0_token() or gargle::gargle2.0_token()
credentials_byo_oauth2(token = my_token)
}
}
\seealso{
Other credential functions: 
\code{\link{credentials_app_default}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_service_account}()},
\code{\link{credentials_user_oauth2}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
