% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token-fetch.R
\name{token_fetch}
\alias{token_fetch}
\title{Fetch a token for the given scopes}
\usage{
token_fetch(scopes = NULL, ...)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/googlescopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email. It is considered a low value scope and
does not appear on the consent screen.}

\item{...}{Additional arguments passed to all credential functions.}
}
\value{
An \code{\link[httr:Token-class]{httr::Token}} or \code{NULL}.
}
\description{
This is a rather magical function that calls a series of concrete
credential-fetching functions, each wrapped in a \code{tryCatch()}.
\code{token_fetch()} keeps trying until it succeeds or there are no more functions
to try. Use \code{\link[=cred_funs_list]{cred_funs_list()}} to see the current registry, in order. See the
vignette \href{https://gargle.r-lib.org/articles/how-gargle-gets-tokens.html}{How gargle gets tokens} for a
full description of \code{token_fetch()}.
}
\examples{
\dontrun{
token_fetch(scopes = "https://www.googleapis.com/auth/userinfo.email")
}
}
\seealso{
Other credential functions: \code{\link{credentials_app_default}},
  \code{\link{credentials_byo_oauth2}},
  \code{\link{credentials_gce}},
  \code{\link{credentials_service_account}},
  \code{\link{credentials_user_oauth2}}
}
\concept{credential functions}
