% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdService.R
\name{gdServiceTrain}
\alias{gdServiceTrain}
\title{Send a request to software service for accelerated training of generative
models to train a generative model for a data source}
\usage{
gdServiceTrain(
  url,
  accessKey,
  generativeModelFileName,
  generativeDataFileName,
  dataSourceFileName,
  trainParameters = gdTrainParameters(numberOfTrainingIterations = 10000,
    numberOfInitializationIterations = 2500, numberOfHiddenLayerUnits = 1024,
    learningRate = 7e-05, dropout = 0.05)
)
}
\arguments{
\item{url}{URL of software service for accelerated training of generative
models}

\item{accessKey}{Unique key for access to software service}

\item{generativeModelFileName}{Name of generative model file}

\item{generativeDataFileName}{Name of generative data file. If name is NULL
or empty string generated data will not be written to a file.}

\item{dataSourceFileName}{Name of data source file}

\item{trainParameters}{Generative model training parameters, see
function gdTrainParameters().}
}
\value{
Job Id number
}
\description{
Send a request to software service to train a generative model. A data source
file will be uploaded and a job for training will be generated. A job id for
the generated job will be returned which has to be used in related requests.
The job will be processed as soon as other waiting jobs are processed. When
a name of an existing generative model file is passed the file will be also
uploaded and the job will continue the training. See also functions
gdTrain(), gdServiceGetGenerativeModel(), gdServiceGetGenerativeData(),
gdServiceGetStatus(), gdServiceDelete().
}
\examples{
\dontrun{
url <- "http://xxx.xxx.xxx.xxx/gdService"
accessKey <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
trainParameters <- gdTrainParameters(numberOfTrainingIterations = 10000)
gdServiceTrain(url, accessKey, "gm.bin", "gd.bin", "ds.bin", trainParameters)}
}
