% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdPlot2dProjection.R
\name{gdPlot2dProjection}
\alias{gdPlot2dProjection}
\title{Create an image file for generative data and data source}
\usage{
gdPlot2dProjection(
  imageFileName,
  title,
  columnIndices,
  generativeDataParameters = gdPlotParameters(numberOfRandomPoints = 0,
    densityValueThresholds = c(), densityValueColors = c("red")),
  dataSourceParameters = gdPlotDataSourceParameters(numberOfRandomPoints = 0, color =
    "blue")
)
}
\arguments{
\item{imageFileName}{Name of image file}

\item{title}{Title of image}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projections. Indices refer to indices of active columns of data source.}

\item{generativeDataParameters}{Plot generative data parameters, see function gdPlotParameters().}

\item{dataSourceParameters}{Plot data source parameters, see function gdPlotDataSourceParameters().}
}
\value{
None
}
\description{
Create an image file containing two-dimensional projections of generative data and data source.
Plot parameters for generative data and data source are passed by functions gdPlotParameters() and
gdPlotDataSourceParameters(). Data points of data source are drawn above data points of generative data.
}
\examples{
\dontrun{gdRead("gd.bin", "iris4d.bin")
gdPlot2dProjection("gd12ddv.png",
 "Generative Data with a Density Value Threshold for the Iris Dataset", c(1, 2),
gdPlotParameters(250000, c(0.71), c("red", "green")),
gdPlotDataSourceParameters(2500))
gdPlot2dProjection("gd34ddv.png",
"Generative Data with a Density Value Threshold for the Iris Dataset", c(3, 4),
gdPlotParameters(250000, c(0.71), c("red", "green")),
gdPlotDataSourceParameters(2500))}
}
