% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_identifiers.R
\name{search_identifiers}
\alias{search_identifiers}
\title{Search for taxa with taxonomic identifiers}
\usage{
search_identifiers(identifier)
}
\arguments{
\item{identifier}{\code{string}: A vector containing one or more taxonomic
identifiers, given as strings.}
}
\value{
An object of class \code{tbl_df}, \code{data.frame} (aka a tibble) and \code{ala_id}
containing taxonomic information.
}
\description{
In the ALA, all records are associated with an identifier that uniquely
identifies the taxon to which that record belongs. Once those identifiers
are known, this function allows you to use them to look up further information
on the taxon in question. Effectively this is the inverse function to
\code{\link[=search_taxa]{search_taxa()}}, which takes names and provides identifiers. The resulting
\code{data.frame} of taxonomic information can also be passed directly to
\code{atlas_} functions to filter records to the specified taxon or taxa.
}
\section{Examples}{


Look up a unique taxon identifier

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_identifiers(identifier = "https://id.biodiversity.org.au/node/apni/2914510")
#> # A tibble: 1 x 14
#>   scient~1 scien~2 taxon~3 rank  match~4 kingdom phylum class order family genus
#>   <chr>    <chr>   <chr>   <chr> <chr>   <chr>   <chr>  <chr> <chr> <chr>  <chr>
#> 1 Eucalyp~ Maiden  https:~ spec~ taxonI~ Plantae Charo~ Equi~ Myrt~ Myrta~ Euca~
#> # ... with 3 more variables: species <chr>, vernacular_name <chr>,
#> #   issues <chr>, and abbreviated variable names 1: scientific_name,
#> #   2: scientific_name_authorship, 3: taxon_concept_id, 4: match_type
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=search_taxa]{search_taxa()}} for how to find species by (scientific) names.
\code{\link[=galah_identify]{galah_identify()}}, \code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict the information returned
by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
