% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_create_ugdag.R
\name{graph-create}
\alias{graph-create}
\alias{ug}
\alias{ugi}
\alias{ugList}
\alias{dag}
\alias{dagi}
\alias{dagList}
\title{Create undirected and directed graphs}
\usage{
ug(..., result = "igraph")

ugi(...)

ugList(x, result = "igraph")

dag(..., result = "igraph", forceCheck = FALSE)

dagi(..., forceCheck = FALSE)

dagList(x, result = "igraph", forceCheck = FALSE)
}
\arguments{
\item{\dots}{A generating class for a graph, see examples below}

\item{result}{The format of the graph. The possible choices are
"graphNEL" (for a \code{graphNEL} object), "igraph" (for an \code{igraph}
object), "matrix" (for an adjacency matrix), "dgCMatrix" (for a
sparse matrix).}

\item{x}{A list or individual components from which a graph can be
created.}

\item{forceCheck}{Logical determining if it should be checked if
the graph is acyclical. Yes, one can specify graphs with cycles
using the \code{dag()} function.}
}
\value{
Functions \code{ug()}, and \code{dag()} can return a
\code{graphNEL} object, an \code{igraph} object, a sparse or a dense
adjacency matrix.
}
\description{
These functions are wrappers for creation of graphs as
implemented by graphNEL objects in the \code{graph} package.
}
\examples{

## The following specifications of undirected graphs are equivalent:
uG1 <- ug(~ a:b:c + c:d)
uG2 <- ug(c("a", "b", "c"), c("c", "d"))
uG3 <- ug(c("a", "b"), c("a", "c"), c("b", "c"), c("c", "d"))

## The following specifications of directed acyclig graphs are equivalent:
daG1 <- dag(~ a:b:c + b:c + c:d)
daG2 <- dag(c("a", "b", "c"), c("b", "c"), c("c", "d"))

## dag() allows to specify directed graphs with cycles:
daG4 <- dag(~ a:b + b:c + c:a) # A directed graph but with cycles

## A check for acyclicity can be done with
## daG5 <- dag(~ a:b + b:c + c:a, forceCheck=TRUE) 

## A check for acyclicity is provided by topoSort
topo_sort( daG2 )
topo_sort( daG4 )

## Different representations
uG7 <- ug(~a:b:c + c:d, result="igraph")    # igraph
uG8 <- ug(~a:b:c + c:d, result="matrix")    # dense matrix
uG9 <- ug(~a:b:c + c:d, result="dgCMatrix") # sparse matrix
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
